/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.AirbornePositionV0Msg;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class AirbornePositionV1Msg
extends AirbornePositionV0Msg
implements Serializable {
    private boolean nic_suppl_a;

    protected AirbornePositionV1Msg() {
    }

    public AirbornePositionV1Msg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public AirbornePositionV1Msg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public AirbornePositionV1Msg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_AIRBORN_POSITION_V1);
    }

    public void setNICSupplementA(boolean nic_suppl) {
        this.nic_suppl_a = nic_suppl;
    }

    public boolean hasNICSupplementA() {
        return this.nic_suppl_a;
    }

    @Override
    public double getHorizontalContainmentRadiusLimit() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 18: 
            case 22: {
                return -1.0;
            }
            case 9: 
            case 20: {
                return 7.5;
            }
            case 10: 
            case 21: {
                return 25.0;
            }
            case 11: {
                return this.nic_suppl_a ? 75.0 : 185.2;
            }
            case 12: {
                return 370.4;
            }
            case 13: {
                return this.nic_suppl_a ? 1111.2 : 926.0;
            }
            case 14: {
                return 1852.0;
            }
            case 15: {
                return 3704.0;
            }
            case 16: {
                return this.nic_suppl_a ? 7408.0 : 14816.0;
            }
            case 17: {
                return 37040.0;
            }
        }
        return -1.0;
    }

    @Override
    public byte getNIC() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 18: 
            case 22: {
                return 0;
            }
            case 9: 
            case 20: {
                return 11;
            }
            case 10: 
            case 21: {
                return 10;
            }
            case 11: {
                return (byte)(this.nic_suppl_a ? 9 : 8);
            }
            case 12: {
                return 7;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 5;
            }
            case 15: {
                return 4;
            }
            case 16: {
                return (byte)(this.nic_suppl_a ? 3 : 2);
            }
            case 17: {
                return 1;
            }
        }
        return 0;
    }
}

