/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.AirbornePositionV1Msg;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class AirbornePositionV2Msg
extends AirbornePositionV1Msg
implements Serializable {
    protected AirbornePositionV2Msg() {
    }

    public AirbornePositionV2Msg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public AirbornePositionV2Msg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public AirbornePositionV2Msg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_AIRBORN_POSITION_V2);
    }

    public boolean hasNICSupplementB() {
        return super.hasSingleAntenna();
    }

    @Override
    public double getHorizontalContainmentRadiusLimit() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 18: 
            case 22: {
                return -1.0;
            }
            case 9: 
            case 20: {
                return 7.5;
            }
            case 10: 
            case 21: {
                return 25.0;
            }
            case 11: {
                return this.hasNICSupplementB() && this.hasNICSupplementA() ? 75.0 : 185.2;
            }
            case 12: {
                return 370.4;
            }
            case 13: {
                if (!this.hasNICSupplementB()) {
                    return 926.0;
                }
                return this.hasNICSupplementA() ? 1111.2 : 555.6;
            }
            case 14: {
                return 1852.0;
            }
            case 15: {
                return 3704.0;
            }
            case 16: {
                return this.hasNICSupplementB() && this.hasNICSupplementA() ? 7408.0 : 14816.0;
            }
            case 17: {
                return 37040.0;
            }
        }
        return -1.0;
    }

    @Override
    public byte getNIC() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 18: 
            case 22: {
                return 0;
            }
            case 9: 
            case 20: {
                return 11;
            }
            case 10: 
            case 21: {
                return 10;
            }
            case 11: {
                return (byte)(this.hasNICSupplementB() && this.hasNICSupplementA() ? 9 : 8);
            }
            case 12: {
                return 7;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 5;
            }
            case 15: {
                return 4;
            }
            case 16: {
                return (byte)(this.hasNICSupplementB() && this.hasNICSupplementA() ? 3 : 2);
            }
            case 17: {
                return 1;
            }
        }
        return 0;
    }
}

