/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class AirspeedHeadingMsg
extends ExtendedSquitter
implements Serializable {
    private static final long serialVersionUID = -7072061713588878404L;
    private byte msg_subtype;
    private boolean intent_change;
    private boolean ifr_capability;
    private byte navigation_accuracy_category;
    private boolean heading_status_bit;
    private double heading;
    private boolean true_airspeed;
    private short airspeed;
    private boolean airspeed_available;
    private boolean vertical_source;
    private boolean vertical_rate_down;
    private short vertical_rate;
    private boolean vertical_rate_info_available;
    private int geo_minus_baro;
    private boolean geo_minus_baro_available;

    protected AirspeedHeadingMsg() {
    }

    public AirspeedHeadingMsg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public AirspeedHeadingMsg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public AirspeedHeadingMsg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_AIRSPEED);
        if (this.getFormatTypeCode() != 19) {
            throw new BadFormatException("Airspeed and heading messages must have typecode 19.");
        }
        byte[] msg = this.getMessage();
        this.msg_subtype = (byte)(msg[0] & 7);
        if (this.msg_subtype != 3 && this.msg_subtype != 4) {
            throw new BadFormatException("Airspeed and heading messages have subtype 3 or 4.");
        }
        this.intent_change = (msg[1] & 0x80) > 0;
        this.ifr_capability = (msg[1] & 0x40) > 0;
        this.navigation_accuracy_category = (byte)(msg[1] >>> 3 & 7);
        this.vertical_rate_info_available = true;
        this.geo_minus_baro_available = true;
        this.heading_status_bit = (msg[1] & 4) > 0;
        this.heading = ((msg[1] & 3) << 8 | msg[2] & 0xFF) * 360 / 1024;
        this.true_airspeed = (msg[3] & 0x80) > 0;
        this.airspeed = (short)(((msg[3] & 0x7F) << 3 | msg[4] >>> 5 & 7) - 1);
        if (this.airspeed != -1) {
            this.airspeed_available = true;
            if (this.msg_subtype == 4) {
                this.airspeed = (short)(this.airspeed << 2);
            }
        }
        this.vertical_source = (msg[4] & 0x10) > 0;
        this.vertical_rate_down = (msg[4] & 8) > 0;
        this.vertical_rate = (short)(((msg[4] & 7) << 6 | msg[5] >>> 2 & 0x3F) - 1 << 6);
        if (this.vertical_rate == -1) {
            this.vertical_rate_info_available = false;
        }
        this.geo_minus_baro = (short)(((msg[6] & 0x7F) - 1) * 25);
        if (this.geo_minus_baro == -1) {
            this.geo_minus_baro_available = false;
        }
        if ((msg[6] & 0x80) > 0) {
            this.geo_minus_baro *= -1;
        }
    }

    public boolean hasHeadingStatusFlag() {
        return this.heading_status_bit;
    }

    public boolean hasAirspeedInfo() {
        return this.airspeed_available;
    }

    public boolean hasVerticalRateInfo() {
        return this.vertical_rate_info_available;
    }

    public boolean hasGeoMinusBaroInfo() {
        return this.geo_minus_baro_available;
    }

    public boolean isSupersonic() {
        return this.msg_subtype == 4;
    }

    public boolean hasChangeIntent() {
        return this.intent_change;
    }

    public boolean hasIFRCapability() {
        return this.ifr_capability;
    }

    public double getNACv() {
        switch (this.navigation_accuracy_category) {
            case 1: {
                return 10.0;
            }
            case 2: {
                return 3.0;
            }
            case 3: {
                return 1.0;
            }
            case 4: {
                return 0.3f;
            }
        }
        return -1.0;
    }

    public Integer getAirspeed() {
        if (!this.airspeed_available) {
            return null;
        }
        return this.airspeed;
    }

    public boolean isBarometricVerticalSpeed() {
        return this.vertical_source;
    }

    public Integer getVerticalRate() {
        if (!this.vertical_rate_info_available) {
            return null;
        }
        return this.vertical_rate_down ? -this.vertical_rate : this.vertical_rate;
    }

    public Integer getGeoMinusBaro() {
        if (!this.geo_minus_baro_available) {
            return null;
        }
        return this.geo_minus_baro;
    }

    public Double getHeading() {
        if (!this.heading_status_bit) {
            return null;
        }
        return this.heading;
    }

    public boolean isTrueAirspeed() {
        return this.true_airspeed;
    }

    @Override
    public String toString() {
        String ret = super.toString() + "\nAirspeed and heading:\n";
        try {
            ret = ret + "\tAirspeed:\t" + this.getAirspeed() + " m/s\n";
        }
        catch (Exception e) {
            ret = ret + "\tAirspeed:\t\tnot available\n";
        }
        ret = ret + "\tAirspeed Type:\t\t" + (this.isTrueAirspeed() ? "true" : "indicated") + "\n";
        try {
            ret = ret + "\tHeading\t\t\t\t" + this.getHeading() + "\n";
        }
        catch (Exception e) {
            ret = ret + "\tHeading\t\t\t\tnot available\n";
        }
        try {
            ret = ret + "\tVertical rate:\t\t\t" + this.getVerticalRate();
        }
        catch (Exception e) {
            ret = ret + "\tVertical rate:\t\t\tnot available";
        }
        return ret;
    }
}

