/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.tools;

public class AllCallReply
extends ModeSReply
implements Serializable {
    private static final long serialVersionUID = -1156158096293306435L;
    private byte capabilities;
    private byte[] parity_interrogator;
    private byte code_label;

    protected AllCallReply() {
    }

    public AllCallReply(String raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public AllCallReply(byte[] raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public AllCallReply(ModeSReply reply) throws BadFormatException {
        super(reply);
        this.setType(ModeSReply.subtype.ALL_CALL_REPLY);
        if (this.getDownlinkFormat() != 11) {
            throw new BadFormatException("Message is not an all-call reply!");
        }
        this.capabilities = this.getFirstField();
        this.parity_interrogator = tools.xor(this.calcParity(), this.getParity());
        this.code_label = (byte)(this.parity_interrogator[2] >> 4 & 7);
    }

    public byte getCapabilities() {
        return this.capabilities;
    }

    public boolean isOnGround() {
        return this.capabilities == 4;
    }

    public boolean isAirborne() {
        return this.capabilities == 5;
    }

    public byte getInterrogatorCode() {
        switch (this.code_label) {
            case 0: 
            case 1: {
                return (byte)(this.parity_interrogator[2] & 0xF);
            }
            case 2: {
                return (byte)((this.parity_interrogator[2] & 0xF) + 16);
            }
            case 3: {
                return (byte)((this.parity_interrogator[2] & 0xF) + 32);
            }
        }
        return (byte)((this.parity_interrogator[2] & 0xF) + 48);
    }

    public boolean isSurveillanceID() {
        return this.code_label > 0;
    }

    public byte getCodeLabel() {
        return this.code_label;
    }

    public boolean hasValidInterrogatorCode() {
        assert (this.parity_interrogator.length == 3);
        if (this.parity_interrogator[0] != 0 || this.parity_interrogator[1] != 0 || (this.parity_interrogator[2] & 0x80) != 0) {
            return false;
        }
        return this.code_label <= 4;
    }

    @Override
    public String toString() {
        return super.toString() + "\nAll-call Reply:\n\tCapabilities:\t\t" + this.getCapabilities() + "\n\tValid Interrogator ID:\t\t" + this.hasValidInterrogatorCode() + "\n" + (this.isSurveillanceID() ? "\tSI-Code:\t\t" : "\tII-Code:\t\t") + this.getInterrogatorCode();
    }
}

