/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ModeSReply;

public class AltitudeReply
extends ModeSReply
implements Serializable {
    private static final long serialVersionUID = -1156158096293306435L;
    private byte flight_status;
    private byte downlink_request;
    private byte utility_msg;
    private short altitude_code;

    protected AltitudeReply() {
    }

    public AltitudeReply(String raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public AltitudeReply(byte[] raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public AltitudeReply(ModeSReply reply) throws BadFormatException {
        super(reply);
        this.setType(ModeSReply.subtype.ALTITUDE_REPLY);
        if (this.getDownlinkFormat() != 4) {
            throw new BadFormatException("Message is not an altitude reply!");
        }
        byte[] payload = this.getPayload();
        this.flight_status = this.getFirstField();
        this.downlink_request = (byte)(payload[0] >>> 3 & 0x1F);
        this.utility_msg = (byte)((payload[0] & 7) << 3 | payload[1] >>> 5 & 7);
        this.altitude_code = (short)((payload[1] << 8 | payload[2] & 0xFF) & 0x1FFF);
    }

    public byte getFlightStatus() {
        return this.flight_status;
    }

    public boolean hasAlert() {
        return this.flight_status >= 2 && this.flight_status <= 4;
    }

    public boolean hasSPI() {
        return this.flight_status == 4 || this.flight_status == 5;
    }

    public boolean isOnGround() {
        return this.flight_status == 1 || this.flight_status == 3;
    }

    public boolean isAirborne() {
        return this.flight_status == 0 || this.flight_status == 2;
    }

    public byte getDownlinkRequest() {
        return this.downlink_request;
    }

    public byte getUtilityMsg() {
        return this.utility_msg;
    }

    public byte getInterrogatorIdentifier() {
        return (byte)(this.utility_msg >>> 2 & 0xF);
    }

    public byte getIdentifierDesignator() {
        return (byte)(this.utility_msg & 3);
    }

    public short getAltitudeCode() {
        return this.altitude_code;
    }

    private static int grayToBin(int gray, int bitlength) {
        int result = 0;
        for (int i = bitlength - 1; i >= 0; --i) {
            result |= (1 << i + 1 & result) >>> 1 ^ 1 << i & gray;
        }
        return result;
    }

    public Integer getAltitude() {
        return AltitudeReply.decodeAltitude(this.altitude_code);
    }

    public static Integer decodeAltitude(short altitude_code) {
        boolean Mbit;
        if (altitude_code == 0) {
            return null;
        }
        boolean bl = Mbit = (altitude_code & 0x40) != 0;
        if (!Mbit) {
            boolean Qbit;
            boolean bl2 = Qbit = (altitude_code & 0x10) != 0;
            if (Qbit) {
                int N = altitude_code & 0xF | (altitude_code & 0x20) >>> 1 | (altitude_code & 0x1F80) >>> 2;
                return 25 * N - 1000;
            }
            int C1 = (0x1000 & altitude_code) >>> 12;
            int A1 = (0x800 & altitude_code) >>> 11;
            int C2 = (0x400 & altitude_code) >>> 10;
            int A2 = (0x200 & altitude_code) >>> 9;
            int C4 = (0x100 & altitude_code) >>> 8;
            int A4 = (0x80 & altitude_code) >>> 7;
            int B1 = (0x20 & altitude_code) >>> 5;
            int B2 = (8 & altitude_code) >>> 3;
            int D2 = (4 & altitude_code) >>> 2;
            int B4 = (2 & altitude_code) >>> 1;
            int D4 = 1 & altitude_code;
            int N500 = AltitudeReply.grayToBin(D2 << 7 | D4 << 6 | A1 << 5 | A2 << 4 | A4 << 3 | B1 << 2 | B2 << 1 | B4, 8);
            int N100 = AltitudeReply.grayToBin(C1 << 2 | C2 << 1 | C4, 3) - 1;
            if (N100 == 6) {
                N100 = 4;
            }
            if (N500 % 2 != 0) {
                N100 = 4 - N100;
            }
            return -1200 + N500 * 500 + N100 * 100;
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + "\nAltitude Reply:\n\tFlight status:\t\t" + this.getFlightStatus() + "\n\tDownlink request:\t\t" + this.getDownlinkRequest() + "\n\tUtility Message:\t\t" + this.getUtilityMsg() + "\n\tAltitude:\t\t" + this.getAltitude();
    }
}

