/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.IdentifyReply;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.tools;

public class CommBIdentifyReply
extends ModeSReply
implements Serializable {
    private static final long serialVersionUID = -1156158096293306435L;
    private byte flight_status;
    private byte downlink_request;
    private byte utility_msg;
    private short identity;
    private byte[] message;

    protected CommBIdentifyReply() {
    }

    public CommBIdentifyReply(String raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public CommBIdentifyReply(byte[] raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public CommBIdentifyReply(ModeSReply reply) throws BadFormatException {
        super(reply);
        this.setType(ModeSReply.subtype.COMM_B_IDENTIFY_REPLY);
        if (this.getDownlinkFormat() != 21) {
            throw new BadFormatException("Message is not a comm-b identify reply!");
        }
        byte[] payload = this.getPayload();
        this.flight_status = this.getFirstField();
        this.downlink_request = (byte)(payload[0] >>> 3 & 0x1F);
        this.utility_msg = (byte)((payload[0] & 7) << 3 | payload[1] >>> 5 & 7);
        this.identity = (short)((payload[1] << 8 | payload[2] & 0xFF) & 0x1FFF);
        this.message = new byte[7];
        for (int i = 0; i < 7; ++i) {
            this.message[i] = payload[i + 3];
        }
    }

    public byte getFlightStatus() {
        return this.flight_status;
    }

    public boolean hasAlert() {
        return this.flight_status >= 2 && this.flight_status <= 4;
    }

    public boolean hasSPI() {
        return this.flight_status == 4 || this.flight_status == 5;
    }

    public boolean isOnGround() {
        return this.flight_status == 1 || this.flight_status == 3;
    }

    public boolean isAirborne() {
        return this.flight_status == 0 || this.flight_status == 2;
    }

    public byte getDownlinkRequest() {
        return this.downlink_request;
    }

    public byte getUtilityMsg() {
        return this.utility_msg;
    }

    public byte getInterrogatorIdentifier() {
        return (byte)(this.utility_msg >>> 2 & 0xF);
    }

    public byte getIdentifierDesignator() {
        return (byte)(this.utility_msg & 3);
    }

    public short getIdentityCode() {
        return this.identity;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public String getIdentity() {
        return IdentifyReply.decodeIdentity(this.identity);
    }

    @Override
    public String toString() {
        return super.toString() + "\nComm-B Identify Reply:\n\tFlight status:\t\t" + this.getFlightStatus() + "\n\tDownlink request:\t\t" + this.getDownlinkRequest() + "\n\tUtility Message:\t\t" + this.getUtilityMsg() + "\n\tIdentity:\t\t" + this.getIdentity() + "\n\tComm-B Message:\t\t" + tools.toHexString(this.getMessage());
    }
}

