/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.tools;

public class CommDExtendedLengthMsg
extends ModeSReply
implements Serializable {
    private static final long serialVersionUID = 1509054097399122428L;
    private byte[] message;
    private boolean ack;
    private byte seqno;

    protected CommDExtendedLengthMsg() {
    }

    public CommDExtendedLengthMsg(String raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public CommDExtendedLengthMsg(byte[] raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public CommDExtendedLengthMsg(ModeSReply reply) throws BadFormatException {
        super(reply);
        this.setType(ModeSReply.subtype.COMM_D_ELM);
        if (this.getDownlinkFormat() < 24) {
            throw new BadFormatException("Message is not an extended length message!");
        }
        this.message = this.getPayload();
        this.ack = (this.getDownlinkFormat() & 2) != 0;
        this.seqno = (byte)((this.getDownlinkFormat() & 1) << 3 | this.getFirstField());
    }

    public byte[] getMessage() {
        return this.message;
    }

    public boolean isAck() {
        return this.ack;
    }

    public byte getSequenceNumber() {
        return this.seqno;
    }

    @Override
    public String toString() {
        return super.toString() + "\nComm-D Extended Length Message:\n\tMessage is " + (this.isAck() ? "an" : "no") + " ACK\n\tSequence number: " + this.getSequenceNumber() + "\n\tComm-B Message:\t\t" + tools.toHexString(this.getMessage());
    }
}

