/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class EmergencyOrPriorityStatusMsg
extends ExtendedSquitter
implements Serializable {
    private static final long serialVersionUID = 7197836328522321081L;
    private byte msgsubtype;
    private byte emergency_state;
    private short mode_a_code;

    protected EmergencyOrPriorityStatusMsg() {
    }

    public EmergencyOrPriorityStatusMsg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public EmergencyOrPriorityStatusMsg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public EmergencyOrPriorityStatusMsg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_EMERGENCY);
        if (this.getFormatTypeCode() != 28) {
            throw new BadFormatException("Emergency and Priority Status messages must have typecode 28.");
        }
        byte[] msg = this.getMessage();
        this.msgsubtype = (byte)(msg[0] & 7);
        if (this.msgsubtype != 1) {
            throw new BadFormatException("Emergency and priority status reports have subtype 1.");
        }
        this.emergency_state = (byte)((msg[1] & 0xFF) >>> 5);
        this.mode_a_code = (short)(msg[2] | (msg[1] & 0x1F) << 8);
    }

    public byte getSubtype() {
        return this.msgsubtype;
    }

    public byte getEmergencyStateCode() {
        return this.emergency_state;
    }

    public String getEmergencyStateText() {
        switch (this.emergency_state) {
            case 0: {
                return "no emergency";
            }
            case 1: {
                return "general emergency";
            }
            case 2: {
                return "lifeguard/medical";
            }
            case 3: {
                return "minimum fuel";
            }
            case 4: {
                return "no communications";
            }
            case 5: {
                return "unlawful interference";
            }
            case 6: {
                return "downed aircraft";
            }
        }
        return "unknown";
    }

    public byte[] getModeACode() {
        int C1 = this.mode_a_code >>> 12 & 1;
        int A1 = this.mode_a_code >>> 11 & 1;
        int C2 = this.mode_a_code >>> 10 & 1;
        int A2 = this.mode_a_code >>> 9 & 1;
        int C4 = this.mode_a_code >>> 8 & 1;
        int A4 = this.mode_a_code >>> 7 & 1;
        int B1 = this.mode_a_code >>> 5 & 1;
        int D1 = this.mode_a_code >>> 4 & 1;
        int B2 = this.mode_a_code >>> 3 & 1;
        int D2 = this.mode_a_code >>> 2 & 1;
        int B4 = this.mode_a_code >>> 1 & 1;
        int D4 = this.mode_a_code & 1;
        return new byte[]{(byte)(A1 + (A2 << 1) + (A4 << 2)), (byte)(B1 + (B2 << 1) + (B4 << 2)), (byte)(C1 + (C2 << 1) + (C4 << 2)), (byte)(D1 + (D2 << 1) + (D4 << 2))};
    }

    @Override
    public String toString() {
        byte[] modeA = this.getModeACode();
        String ret = super.toString() + "\nEmergency & Priority Status:\n";
        ret = ret + "\tEmergency:\t" + this.getEmergencyStateText() + "\n";
        ret = ret + "\tMode A code:\t" + modeA[0] + "|" + modeA[1] + "|" + modeA[2] + "|" + modeA[3];
        return ret;
    }
}

