/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.tools;

public class ExtendedSquitter
extends ModeSReply
implements Serializable {
    private static final long serialVersionUID = -7877955448285410779L;
    private byte capabilities;
    private byte[] message;
    private byte format_type_code;

    protected ExtendedSquitter() {
    }

    public ExtendedSquitter(String raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public ExtendedSquitter(byte[] raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public ExtendedSquitter(ModeSReply reply) throws BadFormatException {
        super(reply);
        this.setType(ModeSReply.subtype.EXTENDED_SQUITTER);
        if (this.getDownlinkFormat() != 17 && this.getDownlinkFormat() != 18) {
            throw new BadFormatException("Message is not an extended squitter!");
        }
        byte[] payload = this.getPayload();
        this.capabilities = this.getFirstField();
        this.message = new byte[7];
        for (int i = 0; i < 7; ++i) {
            this.message[i] = payload[i + 3];
        }
        this.format_type_code = (byte)(this.message[0] >>> 3 & 0x1F);
    }

    public ExtendedSquitter(ExtendedSquitter squitter) {
        super(squitter);
        this.capabilities = squitter.getCapabilities();
        this.message = squitter.getMessage();
        this.format_type_code = squitter.getFormatTypeCode();
    }

    public byte getCapabilities() {
        return this.capabilities;
    }

    public byte getFormatTypeCode() {
        return this.format_type_code;
    }

    public byte[] getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return super.toString() + "\nExtended Squitter:\n\tFormat type code:\t" + this.getFormatTypeCode() + "\n\tCapabilities:\t\t" + this.getCapabilities() + "\n\tMessage field:\t\t" + tools.toHexString(this.getMessage());
    }
}

