/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class IdentificationMsg
extends ExtendedSquitter
implements Serializable {
    private static final long serialVersionUID = -4395826778354619987L;
    private byte emitter_category;
    private byte[] identity;

    private static char mapChar(byte digit) {
        if (digit > 0 && digit < 27) {
            return (char)(65 + digit - 1);
        }
        if (digit > 47 && digit < 58) {
            return (char)(48 + digit - 48);
        }
        return ' ';
    }

    private static char[] mapChar(byte[] digits) {
        char[] result = new char[digits.length];
        for (int i = 0; i < digits.length; ++i) {
            result[i] = IdentificationMsg.mapChar(digits[i]);
        }
        return result;
    }

    protected IdentificationMsg() {
    }

    public IdentificationMsg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public IdentificationMsg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public IdentificationMsg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_IDENTIFICATION);
        if (this.getFormatTypeCode() < 1 || this.getFormatTypeCode() > 4) {
            throw new BadFormatException("Identification messages must have typecode of 1-4.");
        }
        byte[] msg = this.getMessage();
        this.emitter_category = (byte)(msg[0] & 7);
        this.identity = new byte[8];
        for (int i = 8; i >= 1; --i) {
            int byte_off = i * 6 / 8;
            int bit_off = i * 6 % 8;
            if (bit_off == 0) {
                this.identity[i - 1] = (byte)(msg[byte_off] & 0x3F);
                continue;
            }
            this.identity[i - 1] = (byte)(msg[++byte_off] >>> 8 - bit_off & 63 >>> 6 - bit_off);
            if (bit_off >= 6) continue;
            int n = i - 1;
            this.identity[n] = (byte)(this.identity[n] | msg[byte_off - 1] << bit_off & 0x3F);
        }
    }

    public byte getEmitterCategory() {
        return this.emitter_category;
    }

    public char[] getIdentity() {
        return IdentificationMsg.mapChar(this.identity);
    }

    public String getCategoryDescription() {
        String[][] categories = new String[][]{{"No ADS-B Emitter Category Information", "Light (< 15500 lbs)", "Small (15500 to 75000 lbs)", "Large (75000 to 300000 lbs)", "High Vortex Large (aircraft such as B-757)", "Heavy (> 300000 lbs)", "High Performance (> 5g acceleration and 400 kts)", "Rotorcraft"}, {"No ADS-B Emitter Category Information", "Glider / sailplane", "Lighter-than-air", "Parachutist / Skydiver", "Ultralight / hang-glider / paraglider", "Reserved", "Unmanned Aerial Vehicle", "Space / Trans-atmospheric vehicle"}, {"No ADS-B Emitter Category Information", "Surface Vehicle \u2013 Emergency Vehicle", "Surface Vehicle \u2013 Service Vehicle", "Point Obstacle (includes tethered balloons)", "Cluster Obstacle", "Line Obstacle", "Reserved", "Reserved"}, {"Reserved", "Reserved", "Reserved", "Reserved", "Reserved", "Reserved", "Reserved", "Reserved"}};
        return categories[4 - this.getFormatTypeCode()][this.emitter_category];
    }

    @Override
    public String toString() {
        return super.toString() + "\nIdentification:\n\tEmitter category:\t" + this.getCategoryDescription() + " (" + this.getEmitterCategory() + ")\n\tCallsign:\t\t" + new String(this.getIdentity());
    }
}

