/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ModeSReply;

public class IdentifyReply
extends ModeSReply
implements Serializable {
    private static final long serialVersionUID = -1156158096293306435L;
    private byte flight_status;
    private byte downlink_request;
    private byte utility_msg;
    private short identity;

    protected IdentifyReply() {
    }

    public IdentifyReply(String raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public IdentifyReply(byte[] raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public IdentifyReply(ModeSReply reply) throws BadFormatException {
        super(reply);
        this.setType(ModeSReply.subtype.IDENTIFY_REPLY);
        if (this.getDownlinkFormat() != 5) {
            throw new BadFormatException("Message is not an identify reply!");
        }
        byte[] payload = this.getPayload();
        this.flight_status = this.getFirstField();
        this.downlink_request = (byte)(payload[0] >>> 3 & 0x1F);
        this.utility_msg = (byte)((payload[0] & 7) << 3 | payload[1] >>> 5 & 7);
        this.identity = (short)((payload[1] << 8 | payload[2] & 0xFF) & 0x1FFF);
    }

    public byte getFlightStatus() {
        return this.flight_status;
    }

    public boolean hasAlert() {
        return this.flight_status >= 2 && this.flight_status <= 4;
    }

    public boolean hasSPI() {
        return this.flight_status == 4 || this.flight_status == 5;
    }

    public boolean isOnGround() {
        return this.flight_status == 1 || this.flight_status == 3;
    }

    public boolean isAirborne() {
        return this.flight_status == 0 || this.flight_status == 2;
    }

    public byte getDownlinkRequest() {
        return this.downlink_request;
    }

    public byte getUtilityMsg() {
        return this.utility_msg;
    }

    public byte getInterrogatorIdentifier() {
        return (byte)(this.utility_msg >>> 2 & 0xF);
    }

    public byte getIdentifierDesignator() {
        return (byte)(this.utility_msg & 3);
    }

    public short getIdentityCode() {
        return this.identity;
    }

    public String getIdentity() {
        return IdentifyReply.decodeIdentity(this.identity);
    }

    static String decodeIdentity(short identity) {
        int C1 = (0x1000 & identity) >>> 12;
        int A1 = (0x800 & identity) >>> 11;
        int C2 = (0x400 & identity) >>> 10;
        int A2 = (0x200 & identity) >>> 9;
        int C4 = (0x100 & identity) >>> 8;
        int A4 = (0x80 & identity) >>> 7;
        int B1 = (0x20 & identity) >>> 5;
        int D1 = (0x10 & identity) >>> 4;
        int B2 = (8 & identity) >>> 3;
        int D2 = (4 & identity) >>> 2;
        int B4 = (2 & identity) >>> 1;
        int D4 = 1 & identity;
        String A = Integer.toString((A4 << 2) + (A2 << 1) + A1);
        String B = Integer.toString((B4 << 2) + (B2 << 1) + B1);
        String C = Integer.toString((C4 << 2) + (C2 << 1) + C1);
        String D = Integer.toString((D4 << 2) + (D2 << 1) + D1);
        return A + B + C + D;
    }

    @Override
    public String toString() {
        return super.toString() + "\nIdentify Reply:\n\tFlight status:\t\t" + this.getFlightStatus() + "\n\tDownlink request:\t\t" + this.getDownlinkRequest() + "\n\tUtility Message:\t\t" + this.getUtilityMsg() + "\n\tIdentity:\t\t" + this.getIdentity();
    }
}

