/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.AltitudeReply;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.msgs.ShortACAS;

public class LongACAS
extends ModeSReply
implements Serializable {
    private static final long serialVersionUID = -945389130204217847L;
    private boolean airborne;
    private byte sensitivity_level;
    private byte reply_information;
    private short altitude_code;
    private boolean valid_rac;
    private short active_resolution_advisories;
    private byte racs_record;
    private boolean ra_terminated;
    private boolean multiple_threat_encounter;

    protected LongACAS() {
    }

    public LongACAS(String raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public LongACAS(byte[] raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public LongACAS(ModeSReply reply) throws BadFormatException {
        super(reply);
        this.setType(ModeSReply.subtype.LONG_ACAS);
        if (this.getDownlinkFormat() != 16) {
            throw new BadFormatException("Message is not a long ACAS (air-air) message!");
        }
        byte[] payload = this.getPayload();
        this.airborne = (this.getFirstField() & 4) == 0;
        this.sensitivity_level = (byte)(payload[0] >>> 5 & 7);
        this.reply_information = (byte)((payload[0] & 7) << 1 | payload[1] >>> 7 & 1);
        this.altitude_code = (short)((payload[1] << 8 | payload[2] & 0xFF) & 0x1FFF);
        this.valid_rac = payload[3] == 48;
        this.active_resolution_advisories = (short)((payload[4] << 6 | payload[5] >>> 2 & 0x3F) & 0x3FFF);
        this.racs_record = (byte)((payload[5] << 2 | payload[6] >>> 6 & 3) & 0xF);
        this.ra_terminated = (payload[6] >>> 5 & 1) == 1;
        this.multiple_threat_encounter = (payload[6] >>> 4 & 1) == 1;
    }

    public boolean hasValidRAC() {
        return this.valid_rac;
    }

    public short getActiveResolutionAdvisories() {
        return this.active_resolution_advisories;
    }

    public byte getResolutionAdvisoryComplement() {
        return this.racs_record;
    }

    public boolean noPassBelow() {
        return (this.racs_record & 8) == 8;
    }

    public boolean noPassAbove() {
        return (this.racs_record & 4) == 4;
    }

    public boolean noTurnLeft() {
        return (this.racs_record & 2) == 2;
    }

    public boolean noTurnRight() {
        return (this.racs_record & 1) == 1;
    }

    public boolean isAirborne() {
        return this.airborne;
    }

    public boolean hasTerminated() {
        return this.ra_terminated;
    }

    public boolean hasMultipleThreats() {
        return this.multiple_threat_encounter;
    }

    public byte getSensitivityLevel() {
        return this.sensitivity_level;
    }

    public byte getReplyInformation() {
        return this.reply_information;
    }

    public boolean hasOperatingACAS() {
        return this.getReplyInformation() != 0;
    }

    public Integer getMaximumAirspeed() {
        return ShortACAS.decodeMaximumAirspeed(this.getReplyInformation());
    }

    public short getAltitudeCode() {
        return this.altitude_code;
    }

    public Integer getAltitude() {
        return AltitudeReply.decodeAltitude(this.altitude_code);
    }

    @Override
    public String toString() {
        return super.toString() + "\nLong air-air ACAS reply:\n\tAircraft is airborne:\t\t" + this.isAirborne() + "\n\tSensitivity level:\t\t" + this.getSensitivityLevel() + "\n\tHas operating ACAS:\t\t" + this.hasOperatingACAS() + "\n\tMaximum airspeed:\t\t" + this.getMaximumAirspeed() + "\n\tAltitude:\t\t" + this.getAltitude() + "\n\tHas valid RAC:\t" + this.hasValidRAC() + "\n\tActive resolution advisories:\t" + this.getActiveResolutionAdvisories() + "\n\tHas multiple threats:\t" + this.hasMultipleThreats() + "\n\tResolution advisory complement:\t" + this.getResolutionAdvisoryComplement();
    }
}

