/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.apache.commons.lang3.ArrayUtils;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.tools;

public class MilitaryExtendedSquitter
extends ModeSReply
implements Serializable {
    private static final long serialVersionUID = -7877955448285410779L;
    private byte[] message;
    private byte application_code;

    protected MilitaryExtendedSquitter() {
    }

    public MilitaryExtendedSquitter(String raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public MilitaryExtendedSquitter(byte[] raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public MilitaryExtendedSquitter(ModeSReply reply) throws BadFormatException {
        super(reply);
        this.setType(ModeSReply.subtype.MILITARY_EXTENDED_SQUITTER);
        if (this.getDownlinkFormat() != 19) {
            throw new BadFormatException("Message is not a military extended squitter!");
        }
        this.message = ArrayUtils.addAll((byte[])this.getPayload(), (byte[])this.getParity());
        this.application_code = this.getFirstField();
    }

    public MilitaryExtendedSquitter(MilitaryExtendedSquitter squitter) {
        super(squitter);
        this.message = squitter.getMessage();
        this.application_code = squitter.getApplicationCode();
    }

    public byte[] getMessage() {
        return this.message;
    }

    public byte getApplicationCode() {
        return this.application_code;
    }

    @Override
    public String toString() {
        return super.toString() + "\nExtended Squitter:\n\tApplication Code: " + this.getApplicationCode() + "\n\tMessage field:\t\t" + tools.toHexString(this.getMessage());
    }
}

