/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import java.util.Arrays;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.tools;

public class ModeSReply
implements Serializable {
    private static final long serialVersionUID = 5369519167589262290L;
    private byte downlink_format;
    private byte first_field;
    private byte[] icao24;
    private byte[] payload;
    private byte[] parity;
    private boolean noCRC;
    private subtype type;
    public static final byte[] CRC_polynomial = new byte[]{-1, -12, 9};

    public static byte[] calcParity(byte[] msg) {
        byte[] pi = Arrays.copyOf(msg, CRC_polynomial.length);
        for (int i = 0; i < msg.length * 8; ++i) {
            boolean invert = (pi[0] & 0x80) != 0;
            pi[0] = (byte)(pi[0] << 1);
            int b = 1;
            while (b < CRC_polynomial.length) {
                int n = b - 1;
                pi[n] = (byte)(pi[n] | pi[b] >>> 7 & 1);
                int n2 = b++;
                pi[n2] = (byte)(pi[n2] << 1);
            }
            int byteidx = (CRC_polynomial.length * 8 + i) / 8;
            int bitshift = 7 - i % 8;
            if (byteidx < msg.length) {
                int n = pi.length - 1;
                pi[n] = (byte)(pi[n] | msg[byteidx] >>> bitshift & 1);
            }
            if (!invert) continue;
            for (b = 0; b < CRC_polynomial.length; ++b) {
                int n = b;
                pi[n] = (byte)(pi[n] ^ CRC_polynomial[b]);
            }
        }
        return Arrays.copyOf(pi, CRC_polynomial.length);
    }

    public static int getExpectedLength(byte downlink_format) {
        if (downlink_format < 16) {
            return 7;
        }
        return 14;
    }

    protected ModeSReply() {
    }

    public ModeSReply(byte[] reply, boolean noCRC) throws BadFormatException {
        this.noCRC = noCRC;
        if (reply.length != 7 && reply.length != 14) {
            throw new BadFormatException("Raw message has an invalid length of " + reply.length);
        }
        this.downlink_format = reply[0];
        this.first_field = (byte)(this.downlink_format & 7);
        this.downlink_format = (byte)(this.downlink_format >>> 3 & 0x1F);
        if (reply.length != ModeSReply.getExpectedLength(this.downlink_format)) {
            throw new BadFormatException(String.format("Downlink format %d has length %d, but only %d bytes provided.", this.downlink_format, ModeSReply.getExpectedLength(this.downlink_format), reply.length));
        }
        this.payload = Arrays.copyOfRange(reply, 1, reply.length - 3);
        this.parity = Arrays.copyOfRange(reply, reply.length - 3, reply.length);
        this.icao24 = new byte[3];
        switch (this.downlink_format) {
            case 0: 
            case 4: 
            case 5: 
            case 16: 
            case 20: 
            case 21: 
            case 24: {
                this.icao24 = noCRC ? this.parity : tools.xor(this.calcParity(), this.parity);
                break;
            }
            case 11: 
            case 17: 
            case 18: {
                System.arraycopy(this.payload, 0, this.icao24, 0, 3);
                break;
            }
            default: {
                throw new BadFormatException(String.format("Invalid downlink format %d detected.", this.downlink_format));
            }
        }
        this.setType(subtype.MODES_REPLY);
    }

    public ModeSReply(byte[] raw_message) throws BadFormatException {
        this(raw_message, false);
    }

    public ModeSReply(String raw_message) throws BadFormatException {
        this(tools.hexStringToByteArray(raw_message), false);
    }

    public ModeSReply(String raw_message, boolean noCRC) throws BadFormatException {
        this(tools.hexStringToByteArray(raw_message), noCRC);
    }

    public ModeSReply(ModeSReply reply) {
        this.downlink_format = reply.downlink_format;
        this.first_field = reply.first_field;
        this.icao24 = reply.icao24;
        this.payload = reply.payload;
        this.parity = reply.parity;
        this.type = reply.type;
        this.noCRC = reply.noCRC;
    }

    public subtype getType() {
        return this.type;
    }

    protected void setType(subtype subtype2) {
        this.type = subtype2;
    }

    public byte getDownlinkFormat() {
        return this.downlink_format;
    }

    public byte getFirstField() {
        return this.first_field;
    }

    public byte[] getIcao24() {
        return this.icao24;
    }

    public int getTransponderAddress() {
        return (this.icao24[0] & 0xFF) << 16 | (this.icao24[1] & 0xFF) << 8 | this.icao24[2] & 0xFF;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public byte[] getParity() {
        return this.parity;
    }

    public byte[] calcParity() {
        byte[] message = new byte[this.payload.length + 1];
        message[0] = (byte)(this.downlink_format << 3 | this.first_field);
        System.arraycopy(this.payload, 0, message, 1, this.payload.length);
        return ModeSReply.calcParity(message);
    }

    public String getHexMessage() {
        byte[] msg = new byte[4 + this.payload.length];
        msg[0] = (byte)(this.downlink_format << 3 | this.first_field);
        System.arraycopy(this.payload, 0, msg, 1, this.payload.length);
        byte[] crc = this.noCRC ? tools.xor(this.getParity(), this.calcParity()) : this.getParity();
        for (int i = 0; i < 3; ++i) {
            msg[1 + this.payload.length + i] = crc[i];
        }
        return tools.toHexString(msg);
    }

    public boolean checkParity() {
        return tools.areEqual(this.calcParity(), this.getParity());
    }

    public String toString() {
        return "Mode S Reply:\n\tDownlink format:\t" + this.getDownlinkFormat() + "\n\tICAO 24-bit address:\t" + tools.toHexString(this.getIcao24()) + "\n\tPayload:\t\t" + tools.toHexString(this.getPayload()) + "\n\tParity:\t\t\t" + tools.toHexString(this.getParity()) + "\n\tCalculated Parity:\t" + tools.toHexString(this.calcParity());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ModeSReply other = (ModeSReply)o;
        if (this.getDownlinkFormat() != other.getDownlinkFormat()) {
            return false;
        }
        if (this.getDownlinkFormat() == 11 && !tools.areEqual(this.getIcao24(), other.getIcao24())) {
            return false;
        }
        if (this.getDownlinkFormat() == 17 && !tools.areEqual(this.getIcao24(), other.getIcao24())) {
            return false;
        }
        if (this.getDownlinkFormat() == 18 && !tools.areEqual(this.getIcao24(), other.getIcao24())) {
            return false;
        }
        if (!tools.areEqual(this.getPayload(), other.getPayload()) || this.getFirstField() != other.getFirstField()) {
            return false;
        }
        if (tools.areEqual(this.getParity(), other.getParity())) {
            return true;
        }
        if (tools.areEqual(this.getParity(), other.calcParity())) {
            return true;
        }
        if (tools.areEqual(this.calcParity(), other.getParity())) {
            return true;
        }
        if (this.getDownlinkFormat() == 11) {
            if (tools.areEqual(tools.xor(this.calcParity(), this.getParity()), other.getParity())) {
                return true;
            }
            if (tools.areEqual(tools.xor(other.calcParity(), other.getParity()), this.getParity())) {
                return true;
            }
        }
        return tools.areEqual(this.getIcao24(), other.getParity()) || tools.areEqual(this.getParity(), other.getIcao24());
    }

    public int hashCode() {
        int sum = this.downlink_format << 3 | this.first_field;
        for (int i = 0; i < this.payload.length; ++i) {
            sum += this.payload[i] * 31 ^ this.payload.length - i;
        }
        byte[] effective_partiy = this.parity;
        if (this.noCRC) {
            effective_partiy = tools.xor(this.parity, this.calcParity());
        }
        for (int i = 0; i < effective_partiy.length; ++i) {
            sum += effective_partiy[i] * 31 ^ this.payload.length + effective_partiy.length - i;
        }
        return sum;
    }

    public static enum subtype {
        MODES_REPLY,
        SHORT_ACAS,
        ALTITUDE_REPLY,
        IDENTIFY_REPLY,
        ALL_CALL_REPLY,
        LONG_ACAS,
        EXTENDED_SQUITTER,
        MILITARY_EXTENDED_SQUITTER,
        COMM_B_ALTITUDE_REPLY,
        COMM_B_IDENTIFY_REPLY,
        COMM_D_ELM,
        ADSB_AIRBORN_POSITION_V0,
        ADSB_AIRBORN_POSITION_V1,
        ADSB_AIRBORN_POSITION_V2,
        ADSB_SURFACE_POSITION_V0,
        ADSB_SURFACE_POSITION_V1,
        ADSB_SURFACE_POSITION_V2,
        ADSB_AIRSPEED,
        ADSB_EMERGENCY,
        ADSB_TCAS,
        ADSB_VELOCITY,
        ADSB_IDENTIFICATION,
        ADSB_STATUS_V0,
        ADSB_AIRBORN_STATUS_V1,
        ADSB_SURFACE_STATUS_V1,
        ADSB_AIRBORN_STATUS_V2,
        ADSB_SURFACE_STATUS_V2,
        ADSB_TARGET_STATE_AND_STATUS;

    }
}

