/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.exceptions.UnspecifiedFormatError;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class OperationalStatusV0Msg
extends ExtendedSquitter
implements Serializable {
    private byte enroute_capabilities;

    protected OperationalStatusV0Msg() {
    }

    public OperationalStatusV0Msg(String raw_message) throws BadFormatException, UnspecifiedFormatError {
        this(new ExtendedSquitter(raw_message));
    }

    public OperationalStatusV0Msg(byte[] raw_message) throws BadFormatException, UnspecifiedFormatError {
        this(new ExtendedSquitter(raw_message));
    }

    public OperationalStatusV0Msg(ExtendedSquitter squitter) throws BadFormatException, UnspecifiedFormatError {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_STATUS_V0);
        if (this.getFormatTypeCode() != 31) {
            throw new BadFormatException("Operational status messages must have typecode 31.");
        }
        byte[] msg = this.getMessage();
        if (msg[5] >>> 5 != 0) {
            throw new BadFormatException("Not a DO-260/version 0 status message.");
        }
        byte subtype_code = (byte)(msg[0] & 7);
        if (subtype_code > 0) {
            throw new UnspecifiedFormatError("Operational status message subtype " + subtype_code + " reserved.");
        }
        this.enroute_capabilities = msg[1];
    }

    public boolean hasOperationalTCAS() {
        return (this.enroute_capabilities & 0xE0) == 0;
    }

    public boolean hasOperationalCDTI() {
        return (this.enroute_capabilities & 0xD0) == 16;
    }

    public byte getVersion() {
        return 0;
    }
}

