/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.AltitudeReply;
import org.opensky.libadsb.msgs.ModeSReply;

public class ShortACAS
extends ModeSReply
implements Serializable {
    private static final long serialVersionUID = 7201021668905726988L;
    private boolean airborne;
    private boolean cross_link_capability;
    private byte sensitivity_level;
    private byte reply_information;
    private short altitude_code;

    protected ShortACAS() {
    }

    public ShortACAS(String raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public ShortACAS(byte[] raw_message) throws BadFormatException {
        this(new ModeSReply(raw_message));
    }

    public ShortACAS(ModeSReply reply) throws BadFormatException {
        super(reply);
        this.setType(ModeSReply.subtype.SHORT_ACAS);
        if (this.getDownlinkFormat() != 0) {
            throw new BadFormatException("Message is not a short ACAS (air-air) message!");
        }
        byte[] payload = this.getPayload();
        this.airborne = (this.getFirstField() & 4) == 0;
        this.cross_link_capability = (this.getFirstField() & 2) != 0;
        this.sensitivity_level = (byte)(payload[0] >>> 5 & 7);
        this.reply_information = (byte)((payload[0] & 7) << 1 | payload[1] >>> 7 & 1);
        this.altitude_code = (short)((payload[1] << 8 | payload[2] & 0xFF) & 0x1FFF);
    }

    public boolean isAirborne() {
        return this.airborne;
    }

    public boolean hasCrossLinkCapability() {
        return this.cross_link_capability;
    }

    public byte getSensitivityLevel() {
        return this.sensitivity_level;
    }

    public byte getReplyInformation() {
        return this.reply_information;
    }

    public boolean hasOperatingACAS() {
        return this.getReplyInformation() != 0;
    }

    public Integer getMaximumAirspeed() {
        return ShortACAS.decodeMaximumAirspeed(this.getReplyInformation());
    }

    static Integer decodeMaximumAirspeed(byte reply_information) {
        switch (reply_information) {
            case 9: {
                return 75;
            }
            case 10: {
                return 150;
            }
            case 11: {
                return 300;
            }
            case 12: {
                return 600;
            }
            case 13: {
                return 1200;
            }
            case 14: {
                return Integer.MAX_VALUE;
            }
        }
        return null;
    }

    public Boolean hasVerticalResolutionCapability() {
        switch (this.reply_information) {
            case 0: 
            case 1: {
                return false;
            }
            case 3: 
            case 4: {
                return true;
            }
        }
        return null;
    }

    public Boolean hasHorizontalResolutionCapability() {
        switch (this.reply_information) {
            case 0: 
            case 1: 
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return null;
    }

    public short getAltitudeCode() {
        return this.altitude_code;
    }

    public Integer getAltitude() {
        return AltitudeReply.decodeAltitude(this.altitude_code);
    }

    @Override
    public String toString() {
        return super.toString() + "\nShort air-air ACAS reply:\n\tAircraft is airborne:\t\t\t\t" + this.isAirborne() + "\n\tHas cross-link capability:\t\t\t" + this.hasCrossLinkCapability() + "\n\tSensitivity level:\t\t\t\t\t" + this.getSensitivityLevel() + "\n\tHas operating ACAS:\t\t\t\t\t" + this.hasOperatingACAS() + "\n\tMaximum airspeed:\t\t\t\t\t" + this.getMaximumAirspeed() + "\n\tVertical resolution capability:\t\t" + this.hasVerticalResolutionCapability() + "\n\tHorizontal resolution capability:\t" + this.hasHorizontalResolutionCapability() + "\n\tAltitude:\t\t\t\t\t\t\t" + this.getAltitude();
    }
}

