/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.Position;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.exceptions.PositionStraddleError;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.tools;

public class SurfacePositionV0Msg
extends ExtendedSquitter
implements Serializable {
    private static final long serialVersionUID = 8854492255470317616L;
    private boolean horizontal_position_available;
    private byte movement;
    private boolean heading_status;
    private byte ground_track;
    private boolean time_flag;
    private boolean cpr_format;
    private int cpr_encoded_lat;
    private int cpr_encoded_lon;
    private static final int[] lon_offs = new int[]{90, 180, 270};

    protected SurfacePositionV0Msg() {
    }

    public SurfacePositionV0Msg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public SurfacePositionV0Msg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public SurfacePositionV0Msg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_SURFACE_POSITION_V0);
        if (this.getFormatTypeCode() != 0 && (this.getFormatTypeCode() < 5 || this.getFormatTypeCode() > 8)) {
            throw new BadFormatException("This is not a position message! Wrong format type code (" + this.getFormatTypeCode() + ").");
        }
        byte[] msg = this.getMessage();
        this.horizontal_position_available = this.getFormatTypeCode() != 0;
        this.movement = (byte)(((msg[0] & 7) << 4 | (msg[1] & 0xF0) >>> 4) & 0x7F);
        this.heading_status = (msg[1] & 8) != 0;
        this.ground_track = (byte)(((msg[1] & 7) << 4 | (msg[2] & 0xF0) >>> 4) & 0x7F);
        this.time_flag = (msg[2] >>> 3 & 1) == 1;
        this.cpr_format = (msg[2] >>> 2 & 1) == 1;
        this.cpr_encoded_lat = ((msg[2] & 3) << 15 | (msg[3] & 0xFF) << 7 | msg[4] >>> 1 & 0x7F) & 0x1FFFF;
        this.cpr_encoded_lon = ((msg[4] & 1) << 16 | (msg[5] & 0xFF) << 8 | msg[6] & 0xFF) & 0x1FFFF;
    }

    public double getHorizontalContainmentRadiusLimit() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 8: {
                return -1.0;
            }
            case 5: {
                return 7.5;
            }
            case 6: {
                return 25.0;
            }
            case 7: {
                return 185.2;
            }
        }
        return -1.0;
    }

    public byte getNACp() {
        return this.getNIC();
    }

    public double getPositionUncertainty() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 8: {
                return -1.0;
            }
            case 5: {
                return 3.0;
            }
            case 6: {
                return 10.0;
            }
            case 7: {
                return 92.6;
            }
        }
        return -1.0;
    }

    public byte getNIC() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 8: {
                return 0;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 8;
            }
        }
        return 0;
    }

    public byte getSIL() {
        return (byte)(this.getFormatTypeCode() == 0 ? 0 : 2);
    }

    public boolean hasPosition() {
        return this.horizontal_position_available;
    }

    public boolean hasGroundSpeed() {
        return this.movement >= 1 && this.movement <= 124;
    }

    public Double getGroundSpeed() {
        double speed;
        if (this.movement == 1) {
            speed = 0.0;
        } else if (this.movement >= 2 && this.movement <= 8) {
            speed = 0.125 + (double)(this.movement - 2) * 0.125;
        } else if (this.movement >= 9 && this.movement <= 12) {
            speed = 1.0 + (double)(this.movement - 9) * 0.25;
        } else if (this.movement >= 13 && this.movement <= 38) {
            speed = 2.0 + (double)(this.movement - 13) * 0.5;
        } else if (this.movement >= 39 && this.movement <= 93) {
            speed = 15 + (this.movement - 39);
        } else if (this.movement >= 94 && this.movement <= 108) {
            speed = 70 + (this.movement - 94) * 2;
        } else if (this.movement >= 109 && this.movement <= 123) {
            speed = 100 + (this.movement - 109) * 5;
        } else if (this.movement == 124) {
            speed = 175.0;
        } else {
            return null;
        }
        return speed;
    }

    public Double getGroundSpeedResolution() {
        double resolution;
        if (this.movement >= 1 && this.movement <= 8) {
            resolution = 0.125;
        } else if (this.movement >= 9 && this.movement <= 12) {
            resolution = 0.25;
        } else if (this.movement >= 13 && this.movement <= 38) {
            resolution = 0.5;
        } else if (this.movement >= 39 && this.movement <= 93) {
            resolution = 1.0;
        } else if (this.movement >= 94 && this.movement <= 108) {
            resolution = 2.0;
        } else if (this.movement >= 109 && this.movement <= 123) {
            resolution = 5.0;
        } else if (this.movement == 124) {
            resolution = 175.0;
        } else {
            return null;
        }
        return resolution;
    }

    public boolean hasValidHeading() {
        return this.heading_status;
    }

    public Double getHeading() {
        if (!this.heading_status) {
            return null;
        }
        return (double)this.ground_track * 360.0 / 128.0;
    }

    public boolean hasTimeFlag() {
        return this.time_flag;
    }

    public int getCPREncodedLatitude() {
        return this.cpr_encoded_lat;
    }

    public int getCPREncodedLongitude() {
        return this.cpr_encoded_lon;
    }

    public boolean isOddFormat() {
        return this.cpr_format;
    }

    private double NL(double Rlat) {
        if (Rlat == 0.0) {
            return 59.0;
        }
        if (Math.abs(Rlat) == 87.0) {
            return 2.0;
        }
        if (Math.abs(Rlat) > 87.0) {
            return 1.0;
        }
        double tmp = 1.0 - (1.0 - Math.cos(0.10471975511965977)) / Math.pow(Math.cos(Math.PI / 180 * Math.abs(Rlat)), 2.0);
        return Math.floor(Math.PI * 2 / Math.acos(tmp));
    }

    private static double mod(double a, double b) {
        return (a % b + b) % b;
    }

    public Position getGlobalPosition(SurfacePositionV0Msg other, Position ref) throws PositionStraddleError, BadFormatException {
        if (!tools.areEqual(other.getIcao24(), this.getIcao24())) {
            throw new IllegalArgumentException(String.format("Transmitter of other message (%s) not equal to this (%s).", tools.toHexString(other.getIcao24()), tools.toHexString(this.getIcao24())));
        }
        if (other.isOddFormat() == this.isOddFormat()) {
            throw new BadFormatException("Expected " + (this.isOddFormat() ? "even" : "odd") + " message format.", other.toString());
        }
        if (!this.horizontal_position_available || !other.hasPosition()) {
            return null;
        }
        SurfacePositionV0Msg even = this.isOddFormat() ? other : this;
        SurfacePositionV0Msg odd = this.isOddFormat() ? this : other;
        double Dlat0 = 1.5;
        double Dlat1 = 1.5254237288135593;
        double j = Math.floor((59.0 * (double)even.getCPREncodedLatitude() - 60.0 * (double)odd.getCPREncodedLatitude()) / 131072.0 + 0.5);
        double Rlat0 = Dlat0 * (SurfacePositionV0Msg.mod(j, 60.0) + (double)even.getCPREncodedLatitude() / 131072.0);
        double Rlat1 = Dlat1 * (SurfacePositionV0Msg.mod(j, 59.0) + (double)odd.getCPREncodedLatitude() / 131072.0);
        Rlat0 = ref.getLatitude() < Rlat0 - 45.0 ? Rlat0 - 90.0 : Rlat0;
        double d = Rlat1 = ref.getLatitude() < Rlat1 - 45.0 ? Rlat1 - 90.0 : Rlat1;
        if (this.NL(Rlat0) != this.NL(Rlat1)) {
            throw new PositionStraddleError("The two given position straddle a transition latitude and cannot be decoded. Wait for positions where they are equal.");
        }
        double NL_helper = this.NL(Rlat0);
        double n_helper = Math.max(1.0, NL_helper - (this.isOddFormat() ? 1.0 : 0.0));
        double Dlon = 90.0 / n_helper;
        double m = Math.floor(((double)even.getCPREncodedLongitude() * (NL_helper - 1.0) - (double)odd.getCPREncodedLongitude() * NL_helper) / 131072.0 + 0.5);
        double Rlon = Dlon * (SurfacePositionV0Msg.mod(m, n_helper) + (double)(this.isOddFormat() ? odd.getCPREncodedLongitude() : even.getCPREncodedLongitude()) / 131072.0);
        Double lon = Rlon;
        Double lat = this.isOddFormat() ? Rlat1 : Rlat0;
        Position result = new Position(lon, lat, 0.0);
        for (int o : lon_offs) {
            Position tmp = new Position(lon + (double)o, lat, 0.0);
            if (!(tmp.haversine(ref) < result.haversine(ref))) continue;
            result = tmp;
        }
        if (result.getLongitude() > 180.0) {
            result.setLongitude(result.getLongitude() - 360.0);
        }
        return result;
    }

    public Position getLocalPosition(Position ref) {
        if (!this.horizontal_position_available) {
            return null;
        }
        double Dlat = this.isOddFormat() ? 1.5254237288135593 : 1.5;
        double j = Math.floor(ref.getLatitude() / Dlat) + Math.floor(0.5 + SurfacePositionV0Msg.mod(ref.getLatitude(), Dlat) / Dlat - (double)this.getCPREncodedLatitude() / 131072.0);
        double Rlat = Dlat * (j + (double)this.getCPREncodedLatitude() / 131072.0);
        double Dlon = 90.0 / Math.max(1.0, this.NL(Rlat) - (this.isOddFormat() ? 1.0 : 0.0));
        double m = Math.floor(ref.getLongitude() / Dlon) + Math.floor(0.5 + SurfacePositionV0Msg.mod(ref.getLongitude(), Dlon) / Dlon - (double)this.getCPREncodedLongitude() / 131072.0);
        double Rlon = Dlon * (m + (double)this.getCPREncodedLongitude() / 131072.0);
        return new Position(Rlon, Rlat, 0.0);
    }

    @Override
    public String toString() {
        try {
            return super.toString() + "\nSurface Position:\n\tSpeed:\t\t" + (this.hasGroundSpeed() ? this.getGroundSpeed() : "unkown") + "\n\tSpeed Resolution:\t\t" + (this.hasGroundSpeed() ? this.getGroundSpeedResolution() : "unkown") + "\n\tHeading:\t\t" + (this.hasValidHeading() ? this.getHeading() : "unkown") + "\n\tFormat:\t\t" + (this.isOddFormat() ? "odd" : "even") + "\n\tHas position:\t" + (this.hasPosition() ? "yes" : "no");
        }
        catch (Exception e) {
            return "An exception was thrown.";
        }
    }
}

