/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.msgs.SurfacePositionV0Msg;

public class SurfacePositionV1Msg
extends SurfacePositionV0Msg
implements Serializable {
    private boolean nic_suppl_a;

    protected SurfacePositionV1Msg() {
    }

    public SurfacePositionV1Msg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public SurfacePositionV1Msg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public SurfacePositionV1Msg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_SURFACE_POSITION_V1);
    }

    public boolean hasNICSupplementA() {
        return this.nic_suppl_a;
    }

    public void setNICSupplementA(boolean nic_suppl) {
        this.nic_suppl_a = nic_suppl;
    }

    @Override
    public double getHorizontalContainmentRadiusLimit() {
        switch (this.getFormatTypeCode()) {
            case 0: {
                return -1.0;
            }
            case 5: {
                return 7.5;
            }
            case 6: {
                return 25.0;
            }
            case 7: {
                return this.hasNICSupplementA() ? 75.0 : 185.2;
            }
            case 8: {
                return 185.2;
            }
        }
        return -1.0;
    }

    @Override
    public byte getNIC() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 8: {
                return 0;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return (byte)(this.hasNICSupplementA() ? 9 : 8);
            }
        }
        return 0;
    }
}

