/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.msgs.SurfacePositionV1Msg;

public class SurfacePositionV2Msg
extends SurfacePositionV1Msg
implements Serializable {
    private boolean nic_suppl_c;

    protected SurfacePositionV2Msg() {
    }

    public SurfacePositionV2Msg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public SurfacePositionV2Msg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public SurfacePositionV2Msg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_SURFACE_POSITION_V2);
    }

    public boolean hasNICSupplementC() {
        return this.nic_suppl_c;
    }

    public void setNICSupplementC(boolean nic_suppl) {
        this.nic_suppl_c = nic_suppl;
    }

    @Override
    public double getHorizontalContainmentRadiusLimit() {
        switch (this.getFormatTypeCode()) {
            case 0: {
                return -1.0;
            }
            case 5: {
                return 7.5;
            }
            case 6: {
                return 25.0;
            }
            case 7: {
                return (byte)(this.hasNICSupplementA() ? 75.0 : 185.2);
            }
            case 8: {
                if (this.hasNICSupplementC() && this.hasNICSupplementA()) {
                    return 370.4;
                }
                if (this.hasNICSupplementC()) {
                    return 1111.2;
                }
                if (this.hasNICSupplementA()) {
                    return 555.6;
                }
                return -1.0;
            }
        }
        return -1.0;
    }

    @Override
    public byte getNIC() {
        switch (this.getFormatTypeCode()) {
            case 0: {
                return 0;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return (byte)(this.hasNICSupplementA() ? 9 : 8);
            }
            case 8: {
                if (this.hasNICSupplementC() && this.hasNICSupplementA()) {
                    return 7;
                }
                if (this.hasNICSupplementC() || this.hasNICSupplementA()) {
                    return 6;
                }
                return 0;
            }
        }
        return 0;
    }
}

