/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class TCASResolutionAdvisoryMsg
extends ExtendedSquitter
implements Serializable {
    private static final long serialVersionUID = -5356935198993751991L;
    private byte msg_subtype;
    private short active_ra;
    private byte racs_record;
    private boolean ra_terminated;
    private boolean multi_threat_encounter;
    private byte threat_type;
    private int threat_identity;

    protected TCASResolutionAdvisoryMsg() {
    }

    public TCASResolutionAdvisoryMsg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public TCASResolutionAdvisoryMsg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public TCASResolutionAdvisoryMsg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_TCAS);
        if (this.getFormatTypeCode() != 28) {
            throw new BadFormatException("TCAS RA reports must have typecode 28.");
        }
        byte[] msg = this.getMessage();
        this.msg_subtype = (byte)(msg[0] & 7);
        if (this.msg_subtype != 2) {
            throw new BadFormatException("TCAS RA reports have subtype 2.");
        }
        this.active_ra = (short)((msg[2] >>> 2 & 0x3F | msg[1] << 6) & 0x3FFF);
        this.racs_record = (byte)(((msg[2] & 3) << 2 | msg[3] >>> 6 & 3) & 0xF);
        this.ra_terminated = (msg[3] & 0x20) > 0;
        this.multi_threat_encounter = (msg[3] & 0x10) > 0;
        this.threat_type = (byte)(msg[3] >>> 2 & 3);
        this.threat_identity = (msg[6] | msg[5] << 8 | msg[4] << 16 | (msg[4] & 3) << 24) & 0x3FFFFFF;
    }

    public byte getSubtype() {
        return this.msg_subtype;
    }

    public short getActiveRA() {
        return this.active_ra;
    }

    public byte getRACRecord() {
        return this.racs_record;
    }

    public boolean hasRATerminated() {
        return this.ra_terminated;
    }

    public boolean hasMultiThreatEncounter() {
        return this.multi_threat_encounter;
    }

    public byte getThreatType() {
        return this.threat_type;
    }

    public int getThreatIdentity() {
        return this.threat_identity;
    }

    @Override
    public String toString() {
        String ret = super.toString() + "\nTCAS Resolution Advisory:\n";
        ret = ret + "\tActive RAs:\t\t" + this.getActiveRA() + "\n";
        ret = ret + "\tCurrent active RACs:\t" + this.getRACRecord() + "\n";
        ret = ret + "\tRA terminated:\t" + this.hasRATerminated() + "\n";
        ret = ret + "\tMultiple Threats:\t" + this.hasMultiThreatEncounter() + "\n";
        ret = ret + "\tThreat type:\t" + this.getThreatType() + "\n";
        ret = ret + "\tThreat identity:\t" + this.getThreatIdentity();
        return ret;
    }
}

