/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.exceptions.UnspecifiedFormatError;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class TargetStateAndStatusMsg
extends ExtendedSquitter
implements Serializable {
    private boolean sil_suppl;
    private boolean selected_altitude_type;
    private int selected_altitude;
    private int barometric_pressure_setting;
    private boolean selectected_heading_status;
    private boolean selectected_heading_sign;
    private int selected_heading;
    private byte nac_p;
    private boolean nic_baro;
    private byte sil;
    private boolean mcp_fcu_status;
    private boolean autopilot_engaged;
    private boolean vnav_mode_engaged;
    private boolean altitude_hold_mode;
    private boolean approach_mode;
    private boolean has_operational_tcas;
    private boolean lnav_mode_engaged;

    protected TargetStateAndStatusMsg() {
    }

    public TargetStateAndStatusMsg(String raw_message) throws BadFormatException, UnspecifiedFormatError {
        this(new ExtendedSquitter(raw_message));
    }

    public TargetStateAndStatusMsg(byte[] raw_message) throws BadFormatException, UnspecifiedFormatError {
        this(new ExtendedSquitter(raw_message));
    }

    public TargetStateAndStatusMsg(ExtendedSquitter squitter) throws BadFormatException, UnspecifiedFormatError {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_TARGET_STATE_AND_STATUS);
        if (this.getFormatTypeCode() != 29) {
            throw new BadFormatException("Target state and status messages must have typecode 29.");
        }
        byte[] msg = this.getMessage();
        byte subtype_code = (byte)(msg[0] >>> 1 & 3);
        if (subtype_code != 1) {
            throw new UnspecifiedFormatError("Target state and status message subtype " + subtype_code + " reserved.");
        }
        this.sil_suppl = (msg[0] & 1) != 0;
        this.selected_altitude_type = (msg[1] >>> 7 & 1) != 0;
        this.selected_altitude = ((msg[1] & 0x7F) << 4 | msg[2] >>> 4 & 0xF) & 0x7FF;
        this.barometric_pressure_setting = ((msg[2] & 0xF) << 5 | msg[3] >>> 3 & 0x1F) & 0x1FF;
        this.selectected_heading_status = (msg[3] & 4) != 0;
        this.selectected_heading_sign = (msg[3] & 2) != 0;
        this.selected_heading = ((msg[3] & 1) << 7 | msg[4] >>> 1 & 0x7F) & 0xFF;
        this.nac_p = (byte)(((msg[4] & 1) << 3 | msg[5] >>> 5 & 7) & 0xF);
        this.nic_baro = (msg[5] & 0x10) != 0;
        this.sil = (byte)(msg[5] >>> 2 & 3);
        this.mcp_fcu_status = (msg[5] & 2) != 0;
        this.autopilot_engaged = (msg[5] & 1) != 0;
        this.vnav_mode_engaged = (msg[6] & 0x80) != 0;
        this.altitude_hold_mode = (msg[6] & 0x40) != 0;
        this.approach_mode = (msg[6] & 0x10) != 0;
        this.lnav_mode_engaged = (msg[6] & 4) != 0;
        boolean bl = this.has_operational_tcas = (msg[6] & 8) != 0;
        if ((msg[6] & 3) != 0) {
            throw new BadFormatException("Target state and status message reserved bits must be 0.");
        }
    }

    public boolean hasSILSupplement() {
        return this.sil_suppl;
    }

    public boolean hasSelectedAltitudeInfo() {
        return this.selected_altitude > 0;
    }

    public Integer getSelectedAltitude() {
        return this.selected_altitude != 0 ? Integer.valueOf((this.selected_altitude - 1) * 32) : null;
    }

    public boolean isFMSSelectedAltitude() {
        return this.selected_altitude_type;
    }

    public boolean hasBarometricPressureSettingInfo() {
        return this.barometric_pressure_setting != 0;
    }

    public Float getBarometricPressureSetting() {
        return this.barometric_pressure_setting != 0 ? Float.valueOf((float)(this.barometric_pressure_setting - 1) * 0.8f) : null;
    }

    public boolean hasSelectedHeadingInfo() {
        return this.selectected_heading_status;
    }

    public Float getSelectedHeading() {
        if (!this.selectected_heading_status) {
            return null;
        }
        return Float.valueOf((float)this.selected_heading * 0.703125f + (this.selectected_heading_sign ? 180.0f : 0.0f));
    }

    public byte getNACp() {
        return this.nac_p;
    }

    public boolean getBarometricAltitudeIntegrityCode() {
        return this.nic_baro;
    }

    public byte getSIL() {
        return this.sil;
    }

    public boolean hasModeInfo() {
        return this.mcp_fcu_status;
    }

    public Boolean hasAutopilotEngaged() {
        if (!this.mcp_fcu_status) {
            return null;
        }
        return this.autopilot_engaged;
    }

    public Boolean hasVNAVModeEngaged() {
        if (!this.mcp_fcu_status) {
            return null;
        }
        return this.vnav_mode_engaged;
    }

    public Boolean hasActiveAltitudeHoldMode() {
        if (!this.mcp_fcu_status) {
            return null;
        }
        return this.altitude_hold_mode;
    }

    public Boolean hasActiveApproachMode() {
        if (!this.mcp_fcu_status) {
            return null;
        }
        return this.approach_mode;
    }

    public boolean hasOperationalTCAS() {
        return this.has_operational_tcas;
    }

    public Boolean hasLNAVModeEngaged() {
        if (!this.mcp_fcu_status) {
            return null;
        }
        return this.lnav_mode_engaged;
    }
}

