/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class VelocityOverGroundMsg
extends ExtendedSquitter
implements Serializable {
    private static final long serialVersionUID = -7397309420290359454L;
    private byte msg_subtype;
    private boolean intent_change;
    private boolean ifr_capability;
    private byte navigation_accuracy_category;
    private boolean direction_west;
    private short east_west_velocity;
    private boolean velocity_info_available;
    private boolean direction_south;
    private short north_south_velocity;
    private boolean vertical_source;
    private boolean vertical_rate_down;
    private short vertical_rate;
    private boolean vertical_rate_info_available;
    private int geo_minus_baro;
    private boolean geo_minus_baro_available;

    protected VelocityOverGroundMsg() {
    }

    public VelocityOverGroundMsg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public VelocityOverGroundMsg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public VelocityOverGroundMsg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_VELOCITY);
        if (this.getFormatTypeCode() != 19) {
            throw new BadFormatException("Velocity messages must have typecode 19.");
        }
        byte[] msg = this.getMessage();
        this.msg_subtype = (byte)(msg[0] & 7);
        if (this.msg_subtype != 1 && this.msg_subtype != 2) {
            throw new BadFormatException("Ground speed messages have subtype 1 or 2.");
        }
        this.intent_change = (msg[1] & 0x80) > 0;
        this.ifr_capability = (msg[1] & 0x40) > 0;
        this.navigation_accuracy_category = (byte)(msg[1] >>> 3 & 7);
        this.velocity_info_available = true;
        this.vertical_rate_info_available = true;
        this.geo_minus_baro_available = true;
        this.direction_west = (msg[1] & 4) > 0;
        this.east_west_velocity = (short)(((msg[1] & 3) << 8 | msg[2] & 0xFF) - 1);
        if (this.east_west_velocity == -1) {
            this.velocity_info_available = false;
        }
        if (this.msg_subtype == 2) {
            this.east_west_velocity = (short)(this.east_west_velocity << 2);
        }
        this.direction_south = (msg[3] & 0x80) > 0;
        this.north_south_velocity = (short)(((msg[3] & 0x7F) << 3 | msg[4] >>> 5 & 7) - 1);
        if (this.north_south_velocity == -1) {
            this.velocity_info_available = false;
        }
        if (this.msg_subtype == 2) {
            this.north_south_velocity = (short)(this.north_south_velocity << 2);
        }
        this.vertical_source = (msg[4] & 0x10) > 0;
        this.vertical_rate_down = (msg[4] & 8) > 0;
        this.vertical_rate = (short)(((msg[4] & 7) << 6 | msg[5] >>> 2 & 0x3F) - 1 << 6);
        if (this.vertical_rate == -1) {
            this.vertical_rate_info_available = false;
        }
        this.geo_minus_baro = msg[6] & 0x7F;
        if (this.geo_minus_baro == 0) {
            this.geo_minus_baro_available = false;
        } else {
            this.geo_minus_baro = (this.geo_minus_baro - 1) * 25;
        }
        if ((msg[6] & 0x80) > 0) {
            this.geo_minus_baro *= -1;
        }
    }

    public boolean hasVelocityInfo() {
        return this.velocity_info_available;
    }

    public boolean hasVerticalRateInfo() {
        return this.vertical_rate_info_available;
    }

    public boolean hasGeoMinusBaroInfo() {
        return this.geo_minus_baro_available;
    }

    public boolean isSupersonic() {
        return this.msg_subtype == 2;
    }

    public boolean hasChangeIntent() {
        return this.intent_change;
    }

    public boolean hasIFRCapability() {
        return this.ifr_capability;
    }

    public byte getNACv() {
        return this.navigation_accuracy_category;
    }

    public float getAccuracyBound() {
        switch (this.navigation_accuracy_category) {
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 3.0f;
            }
            case 3: {
                return 1.0f;
            }
            case 4: {
                return 0.3f;
            }
        }
        return -1.0f;
    }

    public Integer getEastToWestVelocity() {
        if (!this.velocity_info_available) {
            return null;
        }
        return this.direction_west ? this.east_west_velocity : -this.east_west_velocity;
    }

    public Integer getNorthToSouthVelocity() {
        if (!this.velocity_info_available) {
            return null;
        }
        return this.direction_south ? this.north_south_velocity : -this.north_south_velocity;
    }

    public boolean isBarometricVerticalSpeed() {
        return this.vertical_source;
    }

    public Integer getVerticalRate() {
        if (!this.vertical_rate_info_available) {
            return null;
        }
        return this.vertical_rate_down ? -this.vertical_rate : this.vertical_rate;
    }

    public Integer getGeoMinusBaro() {
        if (!this.geo_minus_baro_available) {
            return null;
        }
        return this.geo_minus_baro;
    }

    public Double getHeading() {
        if (!this.velocity_info_available) {
            return null;
        }
        double angle = Math.toDegrees(Math.atan2(-this.getEastToWestVelocity().intValue(), -this.getNorthToSouthVelocity().intValue()));
        if (angle < 0.0) {
            return 360.0 + angle;
        }
        return angle;
    }

    public Double getVelocity() {
        if (!this.velocity_info_available) {
            return null;
        }
        return Math.hypot(this.north_south_velocity, this.east_west_velocity);
    }

    @Override
    public String toString() {
        String ret = super.toString() + "\nVelocity over ground:\n";
        try {
            ret = ret + "\tNorth to south velocity:\t" + this.getNorthToSouthVelocity() + "\n";
        }
        catch (Exception e) {
            ret = ret + "\tNorth to south velocity:\t\tnot available\n";
        }
        try {
            ret = ret + "\tEast to west velocity:\t\t" + this.getEastToWestVelocity() + "\n";
        }
        catch (Exception e) {
            ret = ret + "\tEast to west velocity:\t\tnot available\n";
        }
        try {
            ret = ret + "\tVelocity:\t\t\t" + this.getVelocity() + "\n";
        }
        catch (Exception e) {
            ret = ret + "\tVelocity:\t\t\tnot available\n";
        }
        try {
            ret = ret + "\tHeading\t\t\t\t" + this.getHeading() + "\n";
        }
        catch (Exception e) {
            ret = ret + "\tHeading\t\t\t\tnot available\n";
        }
        try {
            ret = ret + "\tVertical rate:\t\t\t" + this.getVerticalRate();
        }
        catch (Exception e) {
            ret = ret + "\tVertical rate:\t\t\tnot available";
        }
        return ret;
    }
}

