/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb;

public class tools {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte b) {
        char[] out = new char[]{hexDigits[(0xF0 & b) >>> 4], hexDigits[0xF & b]};
        return new String(out);
    }

    public static String toHexString(byte[] bytes) {
        int l = bytes.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = hexDigits[(0xF0 & bytes[i]) >>> 4];
            out[j++] = hexDigits[0xF & bytes[i]];
        }
        return new String(out);
    }

    public static byte[] hexStringToByteArray(String str) {
        int len = str.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return data;
    }

    public static boolean areEqual(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(char[] array1, char[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte xor(byte byte1, byte byte2) {
        return (byte)(0xFF & (byte1 ^ byte2));
    }

    public static byte[] xor(byte[] array1, byte[] array2) {
        assert (array1.length == array2.length);
        byte[] res = new byte[array1.length];
        for (int i = 0; i < array1.length; ++i) {
            res[i] = tools.xor(array1[i], array2[i]);
        }
        return res;
    }

    public static boolean isZero(byte[] bytes) {
        int x = 0;
        for (int i = 0; i < bytes.length; ++i) {
            x |= bytes[i];
        }
        return x == 0;
    }

    public static Double feet2Meters(Integer ft) {
        if (ft == null) {
            return null;
        }
        return ft.doubleValue() * 0.3048;
    }

    public static Double feet2Meters(Double ft) {
        if (ft == null) {
            return null;
        }
        return ft * 0.3048;
    }

    public static Double meters2Feet(Integer m) {
        if (m == null) {
            return null;
        }
        return m.doubleValue() / 0.3048;
    }

    public static Double meters2Feet(Double m) {
        if (m == null) {
            return null;
        }
        return m / 0.3048;
    }

    public static Double knots2MetersPerSecond(Integer kn) {
        if (kn == null) {
            return null;
        }
        return kn.doubleValue() * 0.514444;
    }

    public static Double knots2MetersPerSecond(Double kn) {
        if (kn == null) {
            return null;
        }
        return kn * 0.514444;
    }

    public static Double feetPerMinute2MetersPerSecond(Integer ftmin) {
        if (ftmin == null) {
            return null;
        }
        return ftmin.doubleValue() * 0.00508;
    }

    public static Double metersPerSecond2Knots(Integer mps) {
        if (mps == null) {
            return null;
        }
        return mps.doubleValue() / 0.514444;
    }

    public static Double metersPerSecond2Knots(Double mps) {
        if (mps == null) {
            return null;
        }
        return mps / 0.514444;
    }

    public static Double metersPerSecond2FeetPerMinute(Integer mps) {
        if (mps == null) {
            return null;
        }
        return mps.doubleValue() / 0.00508;
    }
}

