/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.impl;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.ops4j.pax.jdbc.impl.DriverDataSourceFactory;
import org.ops4j.spi.SafeServiceLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
BundleTrackerCustomizer<List<ServiceRegistration<DataSourceFactory>>> {
    private static Logger log = LoggerFactory.getLogger(Activator.class);
    public static final String BUNDLE_NAME = "org.ops4j.pax.jdbc";
    private BundleTracker<List<ServiceRegistration<DataSourceFactory>>> tracker;

    public void start(BundleContext bc) throws Exception {
        log.debug("starting bundle {}", (Object)BUNDLE_NAME);
        this.tracker = new BundleTracker(bc, 32, (BundleTrackerCustomizer)this);
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        log.debug("stopping bundle {}", (Object)BUNDLE_NAME);
        this.tracker.close();
    }

    public List<ServiceRegistration<DataSourceFactory>> addingBundle(Bundle bundle, BundleEvent event) {
        if (bundle.getBundleId() == 0L) {
            return null;
        }
        try {
            ServiceReference[] registered = bundle.getRegisteredServices();
            ClassLoader cl = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            SafeServiceLoader serviceLoader = new SafeServiceLoader(cl);
            List drivers = serviceLoader.load(Driver.class.getName());
            ArrayList<ServiceRegistration<DataSourceFactory>> registrations = new ArrayList<ServiceRegistration<DataSourceFactory>>();
            for (Driver driver : drivers) {
                boolean alreadyRegistered = false;
                if (registered != null) {
                    for (ServiceReference ref : registered) {
                        if (!this.isSameDataSourceFactory(driver, ref)) continue;
                        alreadyRegistered = true;
                        break;
                    }
                }
                if (alreadyRegistered) continue;
                DriverDataSourceFactory dsf = new DriverDataSourceFactory(driver);
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("osgi.jdbc.driver.class", driver.getClass().getName());
                if (bundle.getSymbolicName() != null) {
                    ((Dictionary)props).put("osgi.jdbc.driver.name", bundle.getSymbolicName());
                }
                if (bundle.getVersion() != null) {
                    ((Dictionary)props).put("osgi.jdbc.driver.version", bundle.getVersion().toString());
                }
                ServiceRegistration reg = bundle.getBundleContext().registerService(DataSourceFactory.class, (Object)dsf, props);
                registrations.add((ServiceRegistration<DataSourceFactory>)reg);
            }
            return registrations.isEmpty() ? null : registrations;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, List<ServiceRegistration<DataSourceFactory>> object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, List<ServiceRegistration<DataSourceFactory>> object) {
        for (ServiceRegistration<DataSourceFactory> reg : object) {
            reg.unregister();
        }
    }

    private boolean isSameDataSourceFactory(Driver driver, ServiceReference<?> ref) {
        Object names = ref.getProperty("objectClass");
        return (names instanceof String && DataSourceFactory.class.getName().equals(names) || names instanceof String[] && DataSourceFactory.class.getName().equals(((String[])names)[0])) && driver.getClass().getName().equals(ref.getProperty("osgi.jdbc.driver.class"));
    }
}

