/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ops4j.pax.runner.CommandLine;

public class CommandLineImpl
implements CommandLine {
    private static final String OPTION_PREFIX = "--";
    public static final Pattern OPTION_PATTERN = Pattern.compile("(.*?)=(.*)");
    private static final String DEFAULT_ARGS_FILE_NAME = "runner.args";
    private static final char LINE_COMMENT_PREFIX = '#';
    private static final String LINE_CONTINUE_CHAR = "\\";
    private final Map<String, List<String>> m_options = new HashMap<String, List<String>>();
    private final List<String> m_arguments = new ArrayList<String>();
    private final String m_localArgsURL;
    private final String m_globalArgsURL;

    public CommandLineImpl(String ... args) {
        this.parseArguments(args == null ? Collections.emptyList() : Arrays.asList(args));
        String argsURL = this.getOption("args");
        boolean useArgsFile = argsURL == null || !argsURL.equalsIgnoreCase("false");
        this.m_localArgsURL = useArgsFile ? this.parseLocalArgs() : null;
        this.m_globalArgsURL = useArgsFile ? this.parseGlobalArgs() : null;
    }

    private String parseLocalArgs() {
        File defaultArgsFile;
        String argsURL = this.getOption("args");
        if (argsURL == null && (defaultArgsFile = new File(DEFAULT_ARGS_FILE_NAME)).exists()) {
            try {
                argsURL = defaultArgsFile.toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (argsURL != null) {
            try {
                this.parseArguments(CommandLineImpl.readTextFile(new URL(argsURL), true));
            }
            catch (IOException e) {
                throw new RuntimeException("Arguments could not be read from [" + argsURL + "]", e);
            }
        }
        return argsURL;
    }

    private String parseGlobalArgs() {
        File defaultGlobalArgsFile;
        String globalArgsURL = this.getOption("globalArgs");
        String userHome = System.getProperty("user.home");
        if (globalArgsURL == null && userHome != null && (defaultGlobalArgsFile = new File(userHome + File.separator + ".pax" + File.separator + "runner" + File.separator + DEFAULT_ARGS_FILE_NAME)).exists()) {
            try {
                globalArgsURL = defaultGlobalArgsFile.toURL().toExternalForm();
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        if (globalArgsURL != null) {
            try {
                this.parseArguments(CommandLineImpl.readTextFile(new URL(globalArgsURL), true));
            }
            catch (IOException e) {
                throw new RuntimeException("Arguments could not be read from [" + globalArgsURL + "]", e);
            }
        }
        return globalArgsURL;
    }

    private void parseArguments(List<String> args) {
        for (String arg : args) {
            if (arg.startsWith(OPTION_PREFIX)) {
                this.parseOption(arg);
                continue;
            }
            this.parseArgument(arg);
        }
        this.initializeProxy();
    }

    @Override
    public String getOption(String key) {
        List<String> values = this.m_options.get(key);
        return values == null || values.size() == 0 ? null : values.get(0);
    }

    @Override
    public String[] getMultipleOption(String key) {
        List<String> values = this.m_options.get(key);
        return values == null || values.size() == 0 ? new String[]{} : values.toArray(new String[values.size()]);
    }

    @Override
    public List<String> getArguments() {
        return this.m_arguments;
    }

    public String getArgumentsFileURL() {
        return this.m_localArgsURL;
    }

    private void parseOption(String arg) {
        String key = arg.substring(2).trim();
        if (key != null && key.length() > 0) {
            List<String> values;
            String value = null;
            Matcher matcher = OPTION_PATTERN.matcher(key);
            if (matcher.matches() && matcher.groupCount() == 2) {
                key = matcher.group(1);
                value = matcher.group(2);
                if ("profiles".equals(key)) {
                    value = value.replace(',', ':');
                }
            }
            if (value == null) {
                value = "true";
                if (key.startsWith("no") && key.length() > 2) {
                    String actualKey = key.substring(2, 3).toLowerCase();
                    if (key.length() >= 3) {
                        key = actualKey + key.substring(3);
                    }
                    value = "false";
                }
            }
            if ((values = this.m_options.get(key)) == null) {
                values = new ArrayList<String>();
                this.m_options.put(key, values);
            }
            values.add(value);
            if ("shell".equals(key)) {
                this.m_options.put("console", Arrays.asList("false"));
                this.addProfile(value);
            }
        }
    }

    private void parseArgument(String arg) {
        if (!(arg.startsWith("scan") || arg.startsWith("/") || arg.contains(":") || arg.split("/").length > 3 || new File(arg).exists())) {
            this.addProfile(arg);
        } else if (!this.m_arguments.contains(arg)) {
            this.m_arguments.add(arg);
        }
    }

    private void addProfile(String profile) {
        if (profile == null || profile.trim().length() == 0) {
            return;
        }
        List<String> profileOption = this.m_options.get("profiles");
        if (profileOption == null) {
            profileOption = new ArrayList<String>();
            profileOption.add(profile);
            this.m_options.put("profiles", profileOption);
        } else {
            String value = profileOption.get(0);
            value = value + ":" + profile;
            profileOption.set(0, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readTextFile(URL fileURL, boolean skipEmptyLines) throws IOException {
        ArrayList<String> content = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new InputStreamReader(fileURL.openStream()));
            StringBuffer entry = new StringBuffer();
            boolean readMore = false;
            while ((line = bufferedReader.readLine()) != null) {
                if (!(skipEmptyLines && line.trim().length() <= 0 || line.charAt(0) == '#')) {
                    if (line.endsWith(LINE_CONTINUE_CHAR)) {
                        entry.append(line.substring(0, line.length() - 1));
                        continue;
                    }
                    entry.append(line);
                    content.add(entry.toString().trim());
                    entry.delete(0, entry.length());
                    continue;
                }
                if (line.trim().length() != 0 || entry.length() <= 0) continue;
                content.add(entry.toString().trim());
                entry.delete(0, entry.length());
            }
            if (entry != null && entry.length() > 0) {
                content.add(entry.toString().trim());
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return content;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.m_localArgsURL != null) {
            builder.append(" and ").append(this.m_localArgsURL);
        }
        if (this.m_globalArgsURL != null) {
            builder.append(" and ").append(this.m_globalArgsURL);
        }
        if (builder.length() > 0) {
            builder.insert(0, "Using arguments from command line");
        } else {
            builder.append("Using only arguments from command line");
        }
        return builder.toString();
    }

    private String toStringAdvanced() {
        StringBuilder builder = new StringBuilder();
        builder.append("Arguments: ");
        for (String string : this.m_arguments) {
            builder.append("[").append(string).append("]");
        }
        builder.append("Options: ");
        for (Map.Entry entry : this.m_options.entrySet()) {
            builder.append("[").append((String)entry.getKey()).append("=").append(entry.getValue()).append("]");
        }
        return builder.toString();
    }

    private void initializeProxy() {
        this.initializeProxy("http");
        this.initializeProxy("https");
        this.initializeProxy("ftp");
        this.initializeSocksProxy();
    }

    private void initializeProxy(String protocol) {
        String nonHosts;
        String port;
        String proxy = this.getOption(protocol + ".proxyHost");
        if (proxy != null) {
            System.setProperty(protocol + ".proxyHost", proxy);
        }
        if ((port = this.getOption(protocol + ".proxyPort")) != null) {
            System.setProperty(protocol + ".proxyPort", port);
        }
        if ((nonHosts = this.getOption(protocol + ".nonProxyHosts")) != null) {
            System.setProperty(protocol + ".nonProxyHosts", nonHosts);
        }
    }

    private void initializeSocksProxy() {
        String port;
        String proxy = this.getOption("socksProxyHost");
        if (proxy != null) {
            System.setProperty("socksProxyHost", proxy);
        }
        if ((port = this.getOption("socksProxyPort")) != null) {
            System.setProperty("socksProxyPort", port);
        }
    }
}

