/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.handler.internal;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.List;
import org.ops4j.lang.NullArgumentException;

public class CompositeURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private final List<URLStreamHandlerFactory> m_factories = new ArrayList<URLStreamHandlerFactory>();

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        for (URLStreamHandlerFactory factory : this.m_factories) {
            URLStreamHandler handler = factory.createURLStreamHandler(protocol);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    public CompositeURLStreamHandlerFactory registerFactory(URLStreamHandlerFactory factory) {
        NullArgumentException.validateNotNull(factory, "Registered factory");
        this.m_factories.add(factory);
        return this;
    }

    public CompositeURLStreamHandlerFactory unregisterFactory(URLStreamHandlerFactory factory) {
        NullArgumentException.validateNotNull(factory, "Unregistered factory");
        this.m_factories.remove(factory);
        return this;
    }
}

