/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.handler.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.handler.internal.CompositeURLStreamHandlerFactory;

public class URLUtils {
    private static final Log LOGGER = LogFactory.getLog(URLUtils.class);

    private URLUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory urlStreamHandlerFactory) {
        try {
            URL.setURLStreamHandlerFactory(urlStreamHandlerFactory);
            return;
        }
        catch (Error err) {
            LOGGER.debug((Object)"URLStreamHandlerFactory already set in the system. Replacing it with a composite");
            Class<URL> clazz = URL.class;
            synchronized (URL.class) {
                URLStreamHandlerFactory currentFactory = URLUtils.resetURLStreamHandlerFactory();
                if (currentFactory == null) {
                    URL.setURLStreamHandlerFactory(urlStreamHandlerFactory);
                } else if (currentFactory instanceof CompositeURLStreamHandlerFactory) {
                    URL.setURLStreamHandlerFactory(currentFactory);
                    ((CompositeURLStreamHandlerFactory)currentFactory).registerFactory(urlStreamHandlerFactory);
                } else {
                    URL.setURLStreamHandlerFactory(new CompositeURLStreamHandlerFactory().registerFactory(urlStreamHandlerFactory).registerFactory(currentFactory));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static URLStreamHandlerFactory resetURLStreamHandlerFactory() {
        Field field = URLUtils.getURLStreamHandlerFactoryField();
        field.setAccessible(true);
        try {
            URLStreamHandlerFactory currentFactory = (URLStreamHandlerFactory)field.get(null);
            field.set(null, null);
            return currentFactory;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access URLStreamHandlerFactory field", e);
        }
    }

    public static URLStreamHandlerFactory getURLStreamHandlerFactory() {
        Field field = URLUtils.getURLStreamHandlerFactoryField();
        field.setAccessible(true);
        try {
            return (URLStreamHandlerFactory)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access URLStreamHandlerFactory field", e);
        }
    }

    private static Field getURLStreamHandlerFactoryField() {
        Field[] fields = URL.class.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(URLStreamHandlerFactory.class)) continue;
                return field;
            }
        }
        throw new RuntimeException("Caanot find URLStreamHandlerFactory field ");
    }
}

