/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.framework;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.ops4j.pax.swissbox.framework.RemoteFramework;
import org.ops4j.pax.swissbox.framework.RemoteServiceReference;
import org.ops4j.pax.swissbox.framework.RemoteServiceReferenceImpl;
import org.ops4j.pax.swissbox.tracker.ServiceLookup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class RemoteFrameworkImpl
implements RemoteFramework {
    private static Logger LOG = Logger.getLogger(RemoteFrameworkImpl.class.getName());
    private Framework framework;
    private Registry registry;
    private String name;
    private long timeout;

    public RemoteFrameworkImpl(Map<String, String> frameworkProperties) throws RemoteException, AlreadyBoundException, BundleException {
        FrameworkFactory frameworkFactory = this.findFrameworkFactory();
        this.framework = frameworkFactory.newFramework(frameworkProperties);
        this.export();
    }

    private void export() throws RemoteException, AccessException {
        String port = System.getProperty("pax.swissbox.framework.rmi.port", "1099");
        this.name = System.getProperty("pax.swissbox.framework.rmi.name");
        this.timeout = Long.parseLong(System.getProperty("pax.swissbox.framework.timeout", "10000"));
        this.registry = LocateRegistry.getRegistry(Integer.parseInt(port));
        URL location1 = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        URL location2 = Bundle.class.getProtectionDomain().getCodeSource().getLocation();
        URL location3 = ServiceLookup.class.getProtectionDomain().getCodeSource().getLocation();
        System.setProperty("java.rmi.server.codebase", location1 + " " + location2 + " " + location3);
        Remote remote = UnicastRemoteObject.exportObject((Remote)this, 0);
        this.registry.rebind(this.name, remote);
    }

    @Override
    public void init() throws RemoteException, BundleException {
        this.framework.init();
    }

    @Override
    public void start() throws RemoteException, BundleException {
        this.framework.start();
    }

    @Override
    public void stop() throws RemoteException, BundleException {
        this.framework.stop();
        try {
            this.framework.waitForStop(this.timeout);
        }
        catch (InterruptedException exc) {
            LOG.severe("framework did not stop within timeout");
        }
        try {
            this.registry.unbind(this.name);
        }
        catch (NotBoundException exc) {
            throw new IllegalStateException(exc);
        }
        UnicastRemoteObject.unexportObject(this, true);
    }

    @Override
    public long installBundle(String bundleUrl) throws RemoteException, BundleException {
        Bundle bundle = this.framework.getBundleContext().installBundle(bundleUrl);
        return bundle.getBundleId();
    }

    @Override
    public long installBundle(String bundleUrl, boolean start, int startLevel) throws RemoteException, BundleException {
        BundleContext bundleContext = this.framework.getBundleContext();
        Bundle bundle = bundleContext.installBundle(bundleUrl);
        RemoteFrameworkImpl.setupBundle(start, startLevel, bundleContext, bundle);
        return bundle.getBundleId();
    }

    @Override
    public long installBundle(String bundleLocation, byte[] bundleData, boolean start, int startLevel) throws RemoteException, BundleException {
        BundleContext bundleContext = this.framework.getBundleContext();
        Bundle bundle = bundleContext.installBundle(bundleLocation, (InputStream)new ByteArrayInputStream(bundleData));
        RemoteFrameworkImpl.setupBundle(start, startLevel, bundleContext, bundle);
        return bundle.getBundleId();
    }

    private static void setupBundle(boolean start, int startLevel, BundleContext bundleContext, Bundle bundle) throws BundleException {
        StartLevel sl = (StartLevel)ServiceLookup.getService((BundleContext)bundleContext, StartLevel.class);
        sl.setBundleStartLevel(bundle, startLevel);
        if (start) {
            bundle.start();
        }
    }

    @Override
    public long installBundle(String bundleLocation, byte[] bundleData) throws RemoteException, BundleException {
        Bundle bundle = this.framework.getBundleContext().installBundle(bundleLocation, (InputStream)new ByteArrayInputStream(bundleData));
        return bundle.getBundleId();
    }

    @Override
    public void startBundle(long bundleId) throws RemoteException, BundleException {
        this.framework.getBundleContext().getBundle(bundleId).start();
    }

    @Override
    public void stopBundle(long bundleId) throws RemoteException, BundleException {
        this.framework.getBundleContext().getBundle(bundleId).stop();
    }

    @Override
    public void setBundleStartLevel(long bundleId, int startLevel) throws RemoteException, BundleException {
        BundleContext bc = this.framework.getBundleContext();
        StartLevel sl = (StartLevel)ServiceLookup.getService((BundleContext)bc, StartLevel.class);
        Bundle bundle = bc.getBundle(bundleId);
        sl.setBundleStartLevel(bundle, startLevel);
    }

    @Override
    public void uninstallBundle(long id) throws RemoteException, BundleException {
        this.framework.getBundleContext().getBundle(id).uninstall();
    }

    public FrameworkFactory findFrameworkFactory() {
        ServiceLoader<FrameworkFactory> loader = ServiceLoader.load(FrameworkFactory.class);
        FrameworkFactory factory = loader.iterator().next();
        return factory;
    }

    private static Map<String, String> buildFrameworkProperties(String[] args) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (String arg : args) {
            if (arg.startsWith("-F")) {
                String key;
                int eq = arg.indexOf("=");
                if (eq == -1) {
                    key = arg.substring(2);
                    props.put(key, null);
                    continue;
                }
                key = arg.substring(2, eq);
                String value = arg.substring(eq + 1);
                props.put(key, value);
                continue;
            }
            LOG.warning("ignoring unknown argument " + arg);
        }
        return props;
    }

    @Override
    public void callService(String filter, String methodName) throws RemoteException, BundleException {
        try {
            LOG.fine("acquiring service " + filter);
            BundleContext bc = this.framework.getBundleContext();
            Object service = ServiceLookup.getServiceByFilter((BundleContext)bc, (String)filter);
            Class<?> klass = service.getClass();
            try {
                Method method = klass.getMethod(methodName, Object[].class);
                LOG.fine("calling service method " + method);
                method.invoke(service, new Object[]{new Object[0]});
            }
            catch (NoSuchMethodException e) {
                Method method = klass.getMethod(methodName, new Class[0]);
                LOG.fine("calling service method  " + method);
                method.invoke(service, new Object[0]);
            }
        }
        catch (SecurityException exc) {
            throw new IllegalStateException(exc);
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalStateException(exc);
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalStateException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new IllegalStateException(exc);
        }
        catch (InvocationTargetException exc) {
            throw new IllegalStateException(exc);
        }
    }

    @Override
    public void setFrameworkStartLevel(int startLevel) throws RemoteException {
        this.setFrameworkStartLevel(startLevel, 0L);
    }

    @Override
    public boolean setFrameworkStartLevel(final int startLevel, long timeout) throws RemoteException {
        BundleContext bc = this.framework.getBundleContext();
        final StartLevel sl = (StartLevel)ServiceLookup.getService((BundleContext)bc, StartLevel.class);
        final CountDownLatch latch = new CountDownLatch(1);
        bc.addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                switch (frameworkEvent.getType()) {
                    case 8: {
                        if (sl.getStartLevel() != startLevel) break;
                        latch.countDown();
                    }
                }
            }
        });
        sl.setStartLevel(startLevel);
        try {
            boolean startLevelReached = latch.await(timeout, TimeUnit.MILLISECONDS);
            return startLevelReached;
        }
        catch (InterruptedException exc) {
            throw new RemoteException("interrupted while waiting", exc);
        }
    }

    @Override
    public void waitForState(long bundleId, int state, long timeoutInMillis) throws RemoteException, BundleException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public int getBundleState(long bundleId) throws RemoteException, BundleException {
        Bundle bundle = this.framework.getBundleContext().getBundle(bundleId);
        if (bundle == null) {
            throw new BundleException(String.format("bundle [%d] does not exist", bundleId));
        }
        return bundle.getState();
    }

    @Override
    public RemoteServiceReference[] getServiceReferences(String filter) throws RemoteException, BundleException, InvalidSyntaxException {
        return this.getServiceReferences(filter, -1L, null);
    }

    @Override
    public RemoteServiceReference[] getServiceReferences(String filter, long timeout, TimeUnit timeUnit) throws RemoteException, BundleException, InvalidSyntaxException {
        BundleContext bundleContext = this.framework.getBundleContext();
        ServiceReference[] serviceReferences = bundleContext.getAllServiceReferences(null, filter);
        if (serviceReferences == null) {
            if (timeout < 0L) {
                return new RemoteServiceReference[0];
            }
            ServiceTracker tracker = new ServiceTracker(bundleContext, bundleContext.createFilter(filter), null);
            tracker.open(true);
            try {
                tracker.waitForService(timeUnit.toMillis(timeout));
                serviceReferences = tracker.getServiceReferences();
                if (serviceReferences == null) {
                    throw new IllegalStateException("services vanished too fast...");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("interrupted!", e);
            }
            finally {
                tracker.close();
            }
        }
        RemoteServiceReference[] remoteRefs = new RemoteServiceReference[serviceReferences.length];
        for (int i = 0; i < remoteRefs.length; ++i) {
            ServiceReference reference = serviceReferences[i];
            String serviceFilter = "(&(service.id=" + reference.getProperty("service.id") + ")" + filter + ")";
            String[] keys = reference.getPropertyKeys();
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (String key : keys) {
                values.put(key, reference.getProperty(key));
            }
            remoteRefs[i] = new RemoteServiceReferenceImpl(values, serviceFilter);
        }
        return remoteRefs;
    }

    @Override
    public Object invokeMethodOnService(RemoteServiceReference reference, String methodName, Object ... args) throws RemoteException, Exception {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < argTypes.length; ++i) {
            Object object = args[i];
            if (object == null) {
                throw new IllegalArgumentException("argument " + i + " is null, use invokeMethodOnService(RemoteServiceReference, String, Class[], Object[]) if you want to call a service with null argument values");
            }
            argTypes[i] = object.getClass();
        }
        return this.invokeMethodOnService(reference, methodName, argTypes, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeMethodOnService(RemoteServiceReference reference, String methodName, Class<?>[] parameterTypes, Object[] args) throws RemoteException, Exception {
        BundleContext bundleContext = this.framework.getBundleContext();
        ServiceReference[] allServiceReferences = bundleContext.getAllServiceReferences(null, reference.getServiceFilter());
        if (allServiceReferences == null || allServiceReferences.length == 0) {
            throw new IllegalStateException("service is no longer present");
        }
        if (allServiceReferences.length > 1) {
            throw new AssertionError((Object)"more than one service is matching the reference, this should never happen");
        }
        Object service = bundleContext.getService(allServiceReferences[0]);
        if (service == null) {
            throw new IllegalStateException("service has vanished between calls");
        }
        try {
            Method method = service.getClass().getMethod(methodName, parameterTypes);
            Object object = method.invoke(service, args);
            return object;
        }
        finally {
            bundleContext.ungetService(allServiceReferences[0]);
        }
    }

    public static void main(String[] args) throws RemoteException, AlreadyBoundException, BundleException, InterruptedException {
        LOG.fine("starting RemoteFrameworkImpl");
        Map<String, String> props = RemoteFrameworkImpl.buildFrameworkProperties(args);
        new RemoteFrameworkImpl(props);
    }
}

