/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketExtensionFactory
extends ExtensionFactory
implements LifeCycle,
Dumpable {
    private ContainerLifeCycle containerLifeCycle;
    private WebSocketContainerScope container;
    private ServiceLoader<Extension> extensionLoader = ServiceLoader.load(Extension.class);
    private Map<String, Class<? extends Extension>> availableExtensions;
    private final InflaterPool inflaterPool = new InflaterPool(-1, true);
    private final DeflaterPool deflaterPool = new DeflaterPool(-1, -1, true);

    public WebSocketExtensionFactory(WebSocketContainerScope container) {
        this.containerLifeCycle = new ContainerLifeCycle(){

            @Override
            public String toString() {
                return String.format("%s@%x{%s}", WebSocketExtensionFactory.class.getSimpleName(), this.hashCode(), WebSocketExtensionFactory.this.containerLifeCycle.getState());
            }
        };
        this.availableExtensions = new HashMap<String, Class<? extends Extension>>();
        for (Extension ext : this.extensionLoader) {
            if (ext == null) continue;
            this.availableExtensions.put(ext.getName(), ext.getClass());
        }
        this.container = container;
        this.containerLifeCycle.addBean(this.inflaterPool);
        this.containerLifeCycle.addBean(this.deflaterPool);
    }

    @Override
    public Map<String, Class<? extends Extension>> getAvailableExtensions() {
        return this.availableExtensions;
    }

    @Override
    public Class<? extends Extension> getExtension(String name) {
        return this.availableExtensions.get(name);
    }

    @Override
    public Set<String> getExtensionNames() {
        return this.availableExtensions.keySet();
    }

    @Override
    public boolean isAvailable(String name) {
        return this.availableExtensions.containsKey(name);
    }

    @Override
    public Extension newInstance(ExtensionConfig config) {
        if (config == null) {
            return null;
        }
        String name = config.getName();
        if (StringUtil.isBlank(name)) {
            return null;
        }
        Class<? extends Extension> extClass = this.getExtension(name);
        if (extClass == null) {
            return null;
        }
        try {
            Extension ext = this.container.getObjectFactory().createInstance(extClass);
            if (ext instanceof AbstractExtension) {
                AbstractExtension aext = (AbstractExtension)ext;
                aext.init(this.container);
                aext.setConfig(config);
            }
            if (ext instanceof CompressExtension) {
                CompressExtension cext = (CompressExtension)ext;
                cext.setInflaterPool(this.inflaterPool);
                cext.setDeflaterPool(this.deflaterPool);
            }
            return ext;
        }
        catch (Exception e) {
            throw new WebSocketException("Cannot instantiate extension: " + extClass, e);
        }
    }

    @Override
    public void register(String name, Class<? extends Extension> extension) {
        this.availableExtensions.put(name, extension);
    }

    @Override
    public void unregister(String name) {
        this.availableExtensions.remove(name);
    }

    @Override
    public Iterator<Class<? extends Extension>> iterator() {
        return this.availableExtensions.values().iterator();
    }

    @Override
    public void start() throws Exception {
        this.containerLifeCycle.start();
    }

    @Override
    public void stop() throws Exception {
        this.containerLifeCycle.stop();
    }

    @Override
    public boolean isRunning() {
        return this.containerLifeCycle.isRunning();
    }

    @Override
    public boolean isStarted() {
        return this.containerLifeCycle.isStarted();
    }

    @Override
    public boolean isStarting() {
        return this.containerLifeCycle.isStarting();
    }

    @Override
    public boolean isStopping() {
        return this.containerLifeCycle.isStopping();
    }

    @Override
    public boolean isStopped() {
        return this.containerLifeCycle.isStopped();
    }

    @Override
    public boolean isFailed() {
        return this.containerLifeCycle.isFailed();
    }

    @Override
    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.containerLifeCycle.addLifeCycleListener(listener);
    }

    @Override
    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this.containerLifeCycle.removeLifeCycleListener(listener);
    }

    @Override
    public String dump() {
        return this.containerLifeCycle.dump();
    }

    @Override
    public String dumpSelf() {
        return this.containerLifeCycle.dumpSelf();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.containerLifeCycle.dump(out, indent);
    }

    public String toString() {
        return this.containerLifeCycle.toString();
    }
}

