/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simplebigdecimal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.Score;

public final class SimpleBigDecimalScore
extends AbstractScore<SimpleBigDecimalScore> {
    public static final SimpleBigDecimalScore ZERO = new SimpleBigDecimalScore(0, BigDecimal.ZERO);
    public static final SimpleBigDecimalScore ONE = new SimpleBigDecimalScore(0, BigDecimal.ONE);
    private final BigDecimal score;

    public static SimpleBigDecimalScore parseScore(String scoreString) {
        String[] scoreTokens = SimpleBigDecimalScore.parseScoreTokens(SimpleBigDecimalScore.class, scoreString, "");
        int initScore = SimpleBigDecimalScore.parseInitScore(SimpleBigDecimalScore.class, scoreString, scoreTokens[0]);
        BigDecimal score = SimpleBigDecimalScore.parseLevelAsBigDecimal(SimpleBigDecimalScore.class, scoreString, scoreTokens[1]);
        return SimpleBigDecimalScore.ofUninitialized(initScore, score);
    }

    public static SimpleBigDecimalScore ofUninitialized(int initScore, BigDecimal score) {
        return new SimpleBigDecimalScore(initScore, score);
    }

    @Deprecated
    public static SimpleBigDecimalScore valueOfUninitialized(int initScore, BigDecimal score) {
        return new SimpleBigDecimalScore(initScore, score);
    }

    public static SimpleBigDecimalScore of(BigDecimal score) {
        return new SimpleBigDecimalScore(0, score);
    }

    @Deprecated
    public static SimpleBigDecimalScore valueOf(BigDecimal score) {
        return new SimpleBigDecimalScore(0, score);
    }

    private SimpleBigDecimalScore() {
        super(Integer.MIN_VALUE);
        this.score = null;
    }

    private SimpleBigDecimalScore(int initScore, BigDecimal score) {
        super(initScore);
        this.score = score;
    }

    public BigDecimal getScore() {
        return this.score;
    }

    @Override
    public SimpleBigDecimalScore toInitializedScore() {
        return this.initScore == 0 ? this : new SimpleBigDecimalScore(0, this.score);
    }

    @Override
    public SimpleBigDecimalScore withInitScore(int newInitScore) {
        this.assertNoInitScore();
        return new SimpleBigDecimalScore(newInitScore, this.score);
    }

    @Override
    public SimpleBigDecimalScore add(SimpleBigDecimalScore addend) {
        return new SimpleBigDecimalScore(this.initScore + addend.getInitScore(), this.score.add(addend.getScore()));
    }

    @Override
    public SimpleBigDecimalScore subtract(SimpleBigDecimalScore subtrahend) {
        return new SimpleBigDecimalScore(this.initScore - subtrahend.getInitScore(), this.score.subtract(subtrahend.getScore()));
    }

    @Override
    public SimpleBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return new SimpleBigDecimalScore((int)Math.floor((double)this.initScore * multiplicand), this.score.multiply(multiplicandBigDecimal).setScale(this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public SimpleBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return new SimpleBigDecimalScore((int)Math.floor((double)this.initScore / divisor), this.score.divide(divisorBigDecimal, this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public SimpleBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return new SimpleBigDecimalScore((int)Math.floor(Math.pow(this.initScore, exponent)), this.score.pow(exponentBigDecimal.intValue()).setScale(this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public SimpleBigDecimalScore negate() {
        return new SimpleBigDecimalScore(-this.initScore, this.score.negate());
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleBigDecimalScore) {
            SimpleBigDecimalScore other = (SimpleBigDecimalScore)o;
            return this.initScore == other.getInitScore() && this.score.stripTrailingZeros().equals(other.getScore().stripTrailingZeros());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.score.stripTrailingZeros());
    }

    @Override
    public int compareTo(SimpleBigDecimalScore other) {
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        return this.score.compareTo(other.getScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0, "");
    }

    public String toString() {
        return this.getInitPrefix() + this.score;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        return otherScore instanceof SimpleBigDecimalScore;
    }
}

