/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simpledouble;

import java.util.Objects;
import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.Score;

public final class SimpleDoubleScore
extends AbstractScore<SimpleDoubleScore> {
    public static final SimpleDoubleScore ZERO = new SimpleDoubleScore(0, 0.0);
    public static final SimpleDoubleScore ONE = new SimpleDoubleScore(0, 1.0);
    private final double score;

    public static SimpleDoubleScore parseScore(String scoreString) {
        String[] scoreTokens = SimpleDoubleScore.parseScoreTokens(SimpleDoubleScore.class, scoreString, "");
        int initScore = SimpleDoubleScore.parseInitScore(SimpleDoubleScore.class, scoreString, scoreTokens[0]);
        double score = SimpleDoubleScore.parseLevelAsDouble(SimpleDoubleScore.class, scoreString, scoreTokens[1]);
        return SimpleDoubleScore.ofUninitialized(initScore, score);
    }

    public static SimpleDoubleScore ofUninitialized(int initScore, double score) {
        return new SimpleDoubleScore(initScore, score);
    }

    @Deprecated
    public static SimpleDoubleScore valueOfUninitialized(int initScore, double score) {
        return new SimpleDoubleScore(initScore, score);
    }

    public static SimpleDoubleScore of(double score) {
        return new SimpleDoubleScore(0, score);
    }

    @Deprecated
    public static SimpleDoubleScore valueOf(double score) {
        return new SimpleDoubleScore(0, score);
    }

    private SimpleDoubleScore() {
        super(Integer.MIN_VALUE);
        this.score = Double.NaN;
    }

    private SimpleDoubleScore(int initScore, double score) {
        super(initScore);
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public SimpleDoubleScore toInitializedScore() {
        return this.initScore == 0 ? this : new SimpleDoubleScore(0, this.score);
    }

    @Override
    public SimpleDoubleScore withInitScore(int newInitScore) {
        this.assertNoInitScore();
        return new SimpleDoubleScore(newInitScore, this.score);
    }

    @Override
    public SimpleDoubleScore add(SimpleDoubleScore addend) {
        return new SimpleDoubleScore(this.initScore + addend.getInitScore(), this.score + addend.getScore());
    }

    @Override
    public SimpleDoubleScore subtract(SimpleDoubleScore subtrahend) {
        return new SimpleDoubleScore(this.initScore - subtrahend.getInitScore(), this.score - subtrahend.getScore());
    }

    @Override
    public SimpleDoubleScore multiply(double multiplicand) {
        return new SimpleDoubleScore((int)Math.floor((double)this.initScore * multiplicand), this.score * multiplicand);
    }

    @Override
    public SimpleDoubleScore divide(double divisor) {
        return new SimpleDoubleScore((int)Math.floor((double)this.initScore / divisor), this.score / divisor);
    }

    @Override
    public SimpleDoubleScore power(double exponent) {
        return new SimpleDoubleScore((int)Math.floor(Math.pow(this.initScore, exponent)), Math.pow(this.score, exponent));
    }

    @Override
    public SimpleDoubleScore negate() {
        return new SimpleDoubleScore(-this.initScore, -this.score);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleDoubleScore) {
            SimpleDoubleScore other = (SimpleDoubleScore)o;
            return this.initScore == other.getInitScore() && this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.score);
    }

    @Override
    public int compareTo(SimpleDoubleScore other) {
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        return Double.compare(this.score, other.getScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> (Double)n != 0.0, "");
    }

    public String toString() {
        return this.getInitPrefix() + this.score;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        return otherScore instanceof SimpleDoubleScore;
    }
}

