/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractBiCollectingGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;

final class DroolsUniToQuadGroupByAccumulator<A, NewA, NewB, NewC, NewD, ResultContainerC, ResultContainerD>
extends DroolsAbstractBiCollectingGroupByAccumulator<ResultContainerC, ResultContainerD, A, BiTuple<NewA, NewB>, QuadTuple<NewA, NewB, NewC, NewD>> {
    private final Function<A, NewA> groupKeyAMapping;
    private final Function<A, NewB> groupKeyBMapping;
    private final Supplier<ResultContainerC> supplierC;
    private final BiFunction<ResultContainerC, A, Runnable> accumulatorC;
    private final Function<ResultContainerC, NewC> finisherC;
    private final Supplier<ResultContainerD> supplierD;
    private final BiFunction<ResultContainerD, A, Runnable> accumulatorD;
    private final Function<ResultContainerD, NewD> finisherD;

    public DroolsUniToQuadGroupByAccumulator(Function<A, NewA> groupKeyAMapping, Function<A, NewB> groupKeyBMapping, UniConstraintCollector<A, ResultContainerC, NewC> collectorC, UniConstraintCollector<A, ResultContainerD, NewD> collectorD) {
        this.groupKeyAMapping = groupKeyAMapping;
        this.groupKeyBMapping = groupKeyBMapping;
        this.supplierC = collectorC.supplier();
        this.accumulatorC = collectorC.accumulator();
        this.finisherC = collectorC.finisher();
        this.supplierD = collectorD.supplier();
        this.accumulatorD = collectorD.accumulator();
        this.finisherD = collectorD.finisher();
    }

    @Override
    protected BiTuple<NewA, NewB> toKey(A a) {
        return new BiTuple<NewA, NewB>(this.groupKeyAMapping.apply(a), this.groupKeyBMapping.apply(a));
    }

    @Override
    protected ResultContainerC newFirstContainer() {
        return this.supplierC.get();
    }

    @Override
    protected ResultContainerD newSecondContainer() {
        return this.supplierD.get();
    }

    @Override
    protected Runnable processFirst(A a, ResultContainerC container) {
        return this.accumulatorC.apply(container, a);
    }

    @Override
    protected Runnable processSecond(A a, ResultContainerD container) {
        return this.accumulatorD.apply(container, a);
    }

    @Override
    protected QuadTuple<NewA, NewB, NewC, NewD> toResult(BiTuple<NewA, NewB> key, ResultContainerC containerC, ResultContainerD containerD) {
        return new QuadTuple(key.a, key.b, this.finisherC.apply(containerC), this.finisherD.apply(containerD));
    }
}

