/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ChainedSwapMove<Solution_>
extends SwapMove<Solution_> {
    protected final List<Object> oldLeftTrailingEntityList;
    protected final List<Object> oldRightTrailingEntityList;

    public ChainedSwapMove(List<GenuineVariableDescriptor<Solution_>> variableDescriptorList, List<SingletonInverseVariableSupply> inverseVariableSupplyList, Object leftEntity, Object rightEntity) {
        super(variableDescriptorList, leftEntity, rightEntity);
        this.oldLeftTrailingEntityList = new ArrayList<Object>(inverseVariableSupplyList.size());
        this.oldRightTrailingEntityList = new ArrayList<Object>(inverseVariableSupplyList.size());
        for (SingletonInverseVariableSupply inverseVariableSupply : inverseVariableSupplyList) {
            boolean hasSupply = inverseVariableSupply != null;
            this.oldLeftTrailingEntityList.add(hasSupply ? inverseVariableSupply.getInverseSingleton(leftEntity) : null);
            this.oldRightTrailingEntityList.add(hasSupply ? inverseVariableSupply.getInverseSingleton(rightEntity) : null);
        }
    }

    public ChainedSwapMove(List<GenuineVariableDescriptor<Solution_>> genuineVariableDescriptors, Object leftEntity, Object rightEntity, List<Object> oldLeftTrailingEntityList, List<Object> oldRightTrailingEntityList) {
        super(genuineVariableDescriptors, leftEntity, rightEntity);
        this.oldLeftTrailingEntityList = oldLeftTrailingEntityList;
        this.oldRightTrailingEntityList = oldRightTrailingEntityList;
    }

    @Override
    public ChainedSwapMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new ChainedSwapMove<Solution_>(this.variableDescriptorList, this.rightEntity, this.leftEntity, this.oldLeftTrailingEntityList, this.oldRightTrailingEntityList);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        for (int i = 0; i < this.variableDescriptorList.size(); ++i) {
            Object oldRightValue;
            GenuineVariableDescriptor variableDescriptor = (GenuineVariableDescriptor)this.variableDescriptorList.get(i);
            Object oldLeftValue = variableDescriptor.getValue(this.leftEntity);
            if (Objects.equals(oldLeftValue, oldRightValue = variableDescriptor.getValue(this.rightEntity))) continue;
            if (!variableDescriptor.isChained()) {
                scoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
                scoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
                continue;
            }
            Object oldLeftTrailingEntity = this.oldLeftTrailingEntityList.get(i);
            Object oldRightTrailingEntity = this.oldRightTrailingEntityList.get(i);
            if (oldRightValue == this.leftEntity) {
                scoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
                scoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, this.rightEntity);
                if (oldRightTrailingEntity == null) continue;
                scoreDirector.changeVariableFacade(variableDescriptor, oldRightTrailingEntity, this.leftEntity);
                continue;
            }
            if (oldLeftValue == this.rightEntity) {
                scoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
                scoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, this.leftEntity);
                if (oldLeftTrailingEntity == null) continue;
                scoreDirector.changeVariableFacade(variableDescriptor, oldLeftTrailingEntity, this.rightEntity);
                continue;
            }
            scoreDirector.changeVariableFacade(variableDescriptor, this.leftEntity, oldRightValue);
            scoreDirector.changeVariableFacade(variableDescriptor, this.rightEntity, oldLeftValue);
            if (oldRightTrailingEntity != null) {
                scoreDirector.changeVariableFacade(variableDescriptor, oldRightTrailingEntity, this.leftEntity);
            }
            if (oldLeftTrailingEntity == null) continue;
            scoreDirector.changeVariableFacade(variableDescriptor, oldLeftTrailingEntity, this.rightEntity);
        }
    }

    @Override
    public ChainedSwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ChainedSwapMove<Solution_>(this.variableDescriptorList, destinationScoreDirector.lookUpWorkingObject(this.leftEntity), destinationScoreDirector.lookUpWorkingObject(this.rightEntity), ChainedSwapMove.rebaseList(this.oldLeftTrailingEntityList, destinationScoreDirector), ChainedSwapMove.rebaseList(this.oldRightTrailingEntityList, destinationScoreDirector));
    }
}

