/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.common;

import java.util.Arrays;

public abstract class AbstractConstraintStreamHelper<Right, JoinedStream, Joiner, Predicate> {
    protected abstract JoinedStream doJoin(Class<Right> var1);

    protected abstract JoinedStream doJoin(Class<Right> var1, Joiner var2);

    protected abstract JoinedStream doJoin(Class<Right> var1, Joiner ... var2);

    protected abstract JoinedStream filter(JoinedStream var1, Predicate var2);

    protected abstract Joiner mergeJoiners(Joiner ... var1);

    protected abstract boolean isFilteringJoiner(Joiner var1);

    protected abstract Predicate extractPredicate(Joiner var1);

    protected abstract Predicate mergePredicates(Predicate var1, Predicate var2);

    public final JoinedStream join(Class<Right> otherClass, Joiner ... joiners) {
        int joinerCount = joiners.length;
        int indexOfFirstFilter = -1;
        for (int i = 0; i < joinerCount; ++i) {
            Joiner joiner = joiners[i];
            if (indexOfFirstFilter >= 0) {
                if (this.isFilteringJoiner(joiner)) continue;
                throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").\nMaybe reorder the joiners such that filtering() joiners are later in the parameter list.");
            }
            if (!this.isFilteringJoiner(joiner)) continue;
            indexOfFirstFilter = i;
        }
        if (indexOfFirstFilter < 0) {
            Joiner mergedJoiners = this.mergeJoiners(joiners);
            return this.doJoin(otherClass, mergedJoiners);
        }
        JoinedStream joined = indexOfFirstFilter == 0 ? this.doJoin(otherClass) : this.doJoin(otherClass, Arrays.copyOf(joiners, indexOfFirstFilter));
        int filterCount = joinerCount - indexOfFirstFilter;
        if (filterCount == 0) {
            return joined;
        }
        Joiner filteringJoiner = joiners[indexOfFirstFilter];
        Predicate resultingFilter = this.extractPredicate(filteringJoiner);
        for (int i = indexOfFirstFilter + 1; i < joinerCount; ++i) {
            Joiner otherFilteringJoiner = joiners[i];
            Predicate otherFilter = this.extractPredicate(otherFilteringJoiner);
            resultingFilter = this.mergePredicates(resultingFilter, otherFilter);
        }
        return this.filter(joined, resultingFilter);
    }
}

