/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.InternalFactHandle;
import org.optaplanner.core.impl.score.stream.drools.common.GroupByCollectorProcessor;

public abstract class DroolsAbstractGroupBy<InTuple, OutTuple>
implements Serializable {
    private static final long serialVersionUID = 510L;
    private final Map<Long, Runnable> undoMap = new HashMap<Long, Runnable>(0);
    private GroupByCollectorProcessor<InTuple, OutTuple> acc;

    public void init() {
        this.acc = this.newAccumulator();
        this.undoMap.clear();
    }

    public void accumulate(InternalFactHandle handle, InTuple input) {
        Runnable undo = this.acc.accumulate(input);
        Runnable oldUndo = this.undoMap.put(handle.getId(), undo);
        if (oldUndo != null) {
            throw new IllegalStateException("Undo for fact handle (" + handle.getId() + ") already exists.");
        }
    }

    public void reverse(InternalFactHandle handle) {
        Runnable undo = this.undoMap.remove(handle.getId());
        if (undo == null) {
            throw new IllegalStateException("No undo for fact handle (" + handle.getId() + ")");
        }
        undo.run();
    }

    public Collection<OutTuple> getResult() {
        return this.acc.finish();
    }

    protected abstract GroupByCollectorProcessor<InTuple, OutTuple> newAccumulator();
}

