/*
 * Decompiled with CFR 0.152.
 */
package org.cts.crs;

import java.util.ArrayList;
import org.cts.Identifier;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.cs.Axis;
import org.cts.cs.CoordinateSystem;
import org.cts.datum.GeodeticDatum;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.CoordinateSwitch;
import org.cts.op.OppositeCoordinate;
import org.cts.op.UnitConversion;
import org.cts.op.projection.Projection;
import org.cts.units.Unit;

public class Geographic3DCRS
extends GeodeticCRS {
    public static CoordinateSystem LATLONH_RRM_CS = new CoordinateSystem(new Axis[]{Axis.LATITUDE, Axis.LONGITUDE, Axis.HEIGHT}, new Unit[]{Unit.RADIAN, Unit.RADIAN, Unit.METER});
    public static CoordinateSystem LONLATH_RRM_CS = new CoordinateSystem(new Axis[]{Axis.LONGITUDE, Axis.LATITUDE, Axis.HEIGHT}, new Unit[]{Unit.RADIAN, Unit.RADIAN, Unit.METER});
    public static CoordinateSystem LATLONH_DDM_CS = new CoordinateSystem(new Axis[]{Axis.LATITUDE, Axis.LONGITUDE, Axis.HEIGHT}, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.METER});
    public static CoordinateSystem LONLATH_DDM_CS = new CoordinateSystem(new Axis[]{Axis.LONGITUDE, Axis.LATITUDE, Axis.HEIGHT}, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.METER});
    public static CoordinateSystem LATLONH_GGM_CS = new CoordinateSystem(new Axis[]{Axis.LATITUDE, Axis.LONGITUDE, Axis.HEIGHT}, new Unit[]{Unit.GRAD, Unit.GRAD, Unit.METER});
    public static CoordinateSystem LONLATH_GGM_CS = new CoordinateSystem(new Axis[]{Axis.LONGITUDE, Axis.LATITUDE, Axis.HEIGHT}, new Unit[]{Unit.GRAD, Unit.GRAD, Unit.METER});

    public Geographic3DCRS(Identifier identifier, GeodeticDatum datum, CoordinateSystem coordSys) {
        super(identifier, datum, coordSys);
    }

    public Geographic3DCRS(Identifier identifier, GeodeticDatum datum, Unit unit) {
        super(identifier, datum, LATLONH_DDM_CS);
        if (unit == Unit.RADIAN) {
            this.coordinateSystem = LATLONH_RRM_CS;
        } else if (unit == Unit.DEGREE) {
            this.coordinateSystem = LATLONH_DDM_CS;
        } else if (unit == Unit.GRAD) {
            this.coordinateSystem = LATLONH_GGM_CS;
        }
    }

    public Geographic3DCRS(Identifier identifier, GeodeticDatum datum) {
        super(identifier, datum, LATLONH_DDM_CS);
    }

    public CoordinateReferenceSystem.Type getType() {
        return CoordinateReferenceSystem.Type.GEOGRAPHIC3D;
    }

    public Projection getProjection() {
        return null;
    }

    public CoordinateOperation toGeographicCoordinateConverter() {
        ArrayList<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        for (int i = 0; i < 3; ++i) {
            if (this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.SOUTH && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.WEST && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.DOWN) continue;
            ops.add(new OppositeCoordinate(i));
        }
        ops.add(UnitConversion.createUnitConverter(this.getCoordinateSystem().getUnit(0), Unit.RADIAN, this.getCoordinateSystem().getUnit(2), Unit.METER));
        if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.EAST || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.WEST) {
            ops.add(CoordinateSwitch.SWITCH_LAT_LON);
        }
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public CoordinateOperation fromGeographicCoordinateConverter() {
        ArrayList<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.EAST || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.WEST) {
            ops.add(CoordinateSwitch.SWITCH_LAT_LON);
        }
        ops.add(UnitConversion.createUnitConverter(Unit.RADIAN, this.getCoordinateSystem().getUnit(0), Unit.METER, this.getCoordinateSystem().getUnit(2)));
        for (int i = 0; i < 3; ++i) {
            if (this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.SOUTH && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.WEST && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.DOWN) continue;
            ops.add(new OppositeCoordinate(i));
        }
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("GEOGCS[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(this.getDatum().toWKT());
        w.append(',');
        w.append(this.getDatum().getPrimeMeridian().toWKT());
        w.append(',');
        w.append(this.getCoordinateSystem().getUnit(0).toWKT());
        for (int i = 0; i < this.getCoordinateSystem().getDimension(); ++i) {
            w.append(',');
            w.append(this.getCoordinateSystem().getAxis(i).toWKT());
        }
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }
}

