/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation.grids;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.cts.cs.GeographicExtent;
import org.cts.op.transformation.grids.GeographicGrid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGNGeographicGrid
extends GeographicGrid {
    static final Logger LOGGER = LoggerFactory.getLogger(IGNGeographicGrid.class);
    String gridType;
    int datumId;
    int coordinateType;
    int geographicDatumId;
    int unit;
    int primeMeridian;
    String interpolationMode;
    String precisionUnit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGNGeographicGrid(InputStream is) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            double ymax;
            double ymin;
            double xmax;
            double xmin;
            ConcurrentHashMap<String, String> precisionCodes = new ConcurrentHashMap<String, String>();
            String gr = reader.readLine();
            StringTokenizer stt = new StringTokenizer(gr, " \t");
            if (!stt.hasMoreTokens()) {
                throw new IOException("Missing information in line : " + gr);
            }
            this.dim = Integer.parseInt(stt.nextToken().substring(2, 3));
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing information in line : " + gr);
            }
            this.gridType = stt.nextToken();
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing information in line : " + gr);
            }
            this.datumId = Integer.parseInt(stt.nextToken());
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing information in line : " + gr);
            }
            String token = stt.nextToken();
            this.coordinateType = Integer.parseInt(token.substring(0, 1));
            this.geographicDatumId = Integer.parseInt(token.substring(1, 4));
            this.unit = Integer.parseInt(token.substring(4, 6));
            this.primeMeridian = Integer.parseInt(token.substring(6, 8));
            String gr1 = reader.readLine();
            stt = new StringTokenizer(gr1, " \t");
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing information in line : " + gr1);
            }
            token = stt.nextToken();
            if (!stt.hasMoreTokens() || !token.endsWith("1")) {
                throw new Exception("Missing min longitude in line : " + gr1);
            }
            token = stt.nextToken();
            this.x0 = xmin = Double.parseDouble(token);
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing maximum longitude in line : " + gr1);
            }
            token = stt.nextToken();
            this.xL = xmax = Double.parseDouble(token);
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing minimum latitude in line : " + gr1);
            }
            token = stt.nextToken();
            this.y0 = ymin = Double.parseDouble(token);
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing maximum latitude in line : " + gr1);
            }
            token = stt.nextToken();
            this.yL = ymax = Double.parseDouble(token);
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing cell size in line : " + gr1);
            }
            token = stt.nextToken();
            this.dx = Double.parseDouble(token);
            double gridWidth = Math.rint((xmax - xmin) * 1.0E12) / 1.0E12;
            this.colNumber = (int)Math.rint(gridWidth / this.dx) + 1;
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing cell size in line : " + gr1);
            }
            token = stt.nextToken();
            this.dy = Double.parseDouble(token);
            double gridHeight = Math.rint((ymax - ymin) * 1.0E12) / 1.0E12;
            this.rowNumber = (int)Math.rint(gridHeight / this.dy) + 1;
            String gr2 = reader.readLine();
            stt = new StringTokenizer(gr2, " \t");
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing information in line : " + gr2);
            }
            token = stt.nextToken();
            if (!stt.hasMoreTokens() || !token.endsWith("2")) {
                throw new Exception("Missing interpolation mode : " + gr2);
            }
            this.interpolationMode = token = stt.nextToken("");
            String gr3 = reader.readLine();
            stt = new StringTokenizer(gr3, " \t");
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing information in line : " + gr3);
            }
            stt.nextToken();
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing information in line : " + gr3);
            }
            stt.nextToken();
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing precision unit in line : " + gr3);
            }
            stt.nextToken();
            this.precisionUnit = stt.nextToken();
            if (stt.hasMoreTokens()) {
                while (stt.hasMoreTokens()) {
                    token = stt.nextToken();
                    String[] precisionCode = token.split("[:>]");
                    if (precisionCode.length != 2) continue;
                    precisionCodes.put(precisionCode[0], precisionCode[1]);
                }
            }
            this.values = new double[this.rowNumber][this.colNumber][this.dim];
            int nbdec = 0;
            while (null != (line = reader.readLine())) {
                String[] gg = line.split("[ \t]+");
                try {
                    double lon = Double.parseDouble(gg[1]);
                    double lat = Double.parseDouble(gg[2]);
                    double[] t = new double[this.dim];
                    for (int i = 0; i < this.dim; ++i) {
                        t[i] = Double.parseDouble(gg[3 + i]);
                    }
                    nbdec = Math.max(nbdec, gg[3].split("\\.")[1].length());
                    System.arraycopy(t, 0, this.values[(int)Math.rint((lat - this.y0) / this.dy)][(int)Math.rint((lon - this.x0) / this.dx)], 0, this.dim);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("Cannot parse the number long : " + gg[0] + " lat : " + gg[1] + " dim :" + gg[2]);
                }
            }
            this.scale = (int)Math.rint(Math.pow(10.0, nbdec));
            this.extent = new GeographicExtent("GG", this.y0, this.yL, this.x0, this.xL, this.modulo);
        }
        finally {
            reader.close();
        }
    }
}

