/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.collections.ImMap;
import org.organicdesign.fp.collections.ImSet;
import org.organicdesign.fp.collections.ImSortedMap;
import org.organicdesign.fp.collections.ImSortedSet;
import org.organicdesign.fp.collections.MutableList;
import org.organicdesign.fp.collections.MutableMap;
import org.organicdesign.fp.collections.MutableSet;
import org.organicdesign.fp.collections.PersistentHashMap;
import org.organicdesign.fp.collections.PersistentHashSet;
import org.organicdesign.fp.collections.PersistentTreeMap;
import org.organicdesign.fp.collections.PersistentTreeSet;
import org.organicdesign.fp.collections.PersistentVector;
import org.organicdesign.fp.collections.RrbTree;
import org.organicdesign.fp.collections.UnmodIterable;
import org.organicdesign.fp.collections.UnmodIterator;
import org.organicdesign.fp.tuple.Tuple2;
import org.organicdesign.fp.tuple.Tuple3;
import org.organicdesign.fp.xform.Xform;

public final class StaticImports {
    private StaticImports() {
        throw new UnsupportedOperationException("No instantiation");
    }

    @SafeVarargs
    public static <K, V> ImMap<K, V> map(Map.Entry<K, V> ... kvPairs) {
        if (kvPairs == null || kvPairs.length < 1) {
            return PersistentHashMap.empty();
        }
        return PersistentHashMap.of(Arrays.asList(kvPairs));
    }

    @SafeVarargs
    public static <K, V> MutableMap<K, V> mutableMap(Map.Entry<K, V> ... kvPairs) {
        PersistentHashMap.MutableHashMap ret = PersistentHashMap.emptyMutable();
        if (kvPairs == null) {
            return ret;
        }
        for (Map.Entry<K, V> me : kvPairs) {
            ret.assoc((Map.Entry)me);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> RrbTree.MutableRrbt<T> mutableRrb(T ... items) {
        if (items == null || items.length < 1) {
            return RrbTree.emptyMutable();
        }
        return RrbTree.emptyMutable().concat(Arrays.asList(items));
    }

    @SafeVarargs
    public static <T> MutableSet<T> mutableSet(T ... items) {
        PersistentHashSet.MutableHashSet ret = PersistentHashSet.emptyMutable();
        if (items == null) {
            return ret;
        }
        for (T t : items) {
            ret.put(t);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> MutableList<T> mutableVec(T ... items) {
        PersistentVector.MutableVector ret = PersistentVector.emptyMutable();
        if (items == null) {
            return ret;
        }
        for (T t : items) {
            ret.append(t);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> RrbTree.ImRrbt<T> rrb(T ... items) {
        if (items == null || items.length < 1) {
            return RrbTree.empty();
        }
        return StaticImports.mutableRrb(items).immutable();
    }

    @SafeVarargs
    public static <T> ImSet<T> set(T ... items) {
        if (items == null || items.length < 1) {
            return PersistentHashSet.empty();
        }
        return PersistentHashSet.of(Arrays.asList(items));
    }

    public static <K, V> ImSortedMap<K, V> sortedMap(Comparator<? super K> comp, Iterable<Map.Entry<K, V>> kvPairs) {
        return PersistentTreeMap.ofComp(comp, kvPairs);
    }

    public static <K extends Comparable<K>, V> ImSortedMap<K, V> sortedMap(Iterable<Map.Entry<K, V>> kvPairs) {
        return PersistentTreeMap.of(kvPairs);
    }

    public static <T> ImSortedSet<T> sortedSet(Comparator<? super T> comp, Iterable<T> elements) {
        return Xform.of(elements).toImSortedSet(comp);
    }

    public static <T extends Comparable<T>> ImSortedSet<T> sortedSet(Iterable<T> items) {
        return PersistentTreeSet.of(items);
    }

    public static <T, U> Tuple2<T, U> tup(T t, U u) {
        return Tuple2.of(t, u);
    }

    public static <T, U, V> Tuple3<T, U, V> tup(T t, U u, V v) {
        return Tuple3.of(t, u, v);
    }

    @SafeVarargs
    public static <T> ImList<T> vec(T ... items) {
        if (items == null || items.length < 1) {
            return PersistentVector.empty();
        }
        return StaticImports.mutableVec(items).immutable();
    }

    public static <T> UnmodIterable<T> xform(Iterable<T> iterable) {
        return Xform.of(iterable);
    }

    @SafeVarargs
    public static <T> UnmodIterable<T> xformArray(T ... items) {
        return Xform.of(Arrays.asList(items));
    }

    public static UnmodIterable<Character> xformChars(final CharSequence seq) {
        return new UnmodIterable<Character>(){

            @Override
            public UnmodIterator<Character> iterator() {
                return new UnmodIterator<Character>(){
                    private int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < seq.length();
                    }

                    @Override
                    public Character next() {
                        int nextIdx = this.idx + 1;
                        Character c = Character.valueOf(seq.charAt(this.idx));
                        this.idx = nextIdx;
                        return c;
                    }
                };
            }
        };
    }
}

