/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.organicdesign.fp.tuple.Tuple2;

public final class Cowry {
    static final Object[] EMPTY_ARRAY = new Object[0];

    private Cowry() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static <T> T[] emptyArray() {
        return EMPTY_ARRAY;
    }

    static <T> T[] singleElementArray(T elem) {
        return new Object[]{elem};
    }

    public static <T> T[] singleElementArray(T elem, Class<T> tClass) {
        if (tClass == null) {
            return new Object[]{elem};
        }
        Object[] newItems = (Object[])Array.newInstance(tClass, 1);
        newItems[0] = elem;
        return newItems;
    }

    public static <T> T[] insertIntoArrayAt(T item, T[] items, int idx, Class<T> tClass) {
        Object newItems;
        Object object = newItems = tClass == null ? new Object[items.length + 1] : Array.newInstance(tClass, items.length + 1);
        if (idx > 0) {
            System.arraycopy(items, 0, newItems, 0, idx);
        }
        newItems[idx] = item;
        if (idx < items.length) {
            System.arraycopy(items, idx, newItems, idx + 1, items.length - idx);
        }
        return newItems;
    }

    public static <T> T[] arrayCopy(T[] items, int length, Class<T> tClass) {
        Object newItems;
        Object object = newItems = tClass == null ? new Object[length] : Array.newInstance(tClass, length);
        if (length > 0) {
            System.arraycopy(items, 0, newItems, 0, items.length < length ? items.length : length);
        }
        return newItems;
    }

    public static <A> A[] spliceIntoArrayAt(A[] insertedItems, A[] origItems, int idx, Class<A> tClass) {
        Object[] newItems;
        Object[] objectArray = newItems = tClass == null ? new Object[insertedItems.length + origItems.length] : (Object[])Array.newInstance(tClass, insertedItems.length + origItems.length);
        if (idx > 0) {
            System.arraycopy(origItems, 0, newItems, 0, idx);
        }
        System.arraycopy(insertedItems, 0, newItems, idx, insertedItems.length);
        if (idx < origItems.length) {
            System.arraycopy(origItems, idx, newItems, idx + insertedItems.length, origItems.length - idx);
        }
        return newItems;
    }

    public static <T> T[] replaceInArrayAt(T replacedItem, T[] origItems, int idx, Class<T> tClass) {
        Object newItems = tClass == null ? new Object[origItems.length] : Array.newInstance(tClass, origItems.length);
        System.arraycopy(origItems, 0, newItems, 0, origItems.length);
        newItems[idx] = replacedItem;
        return newItems;
    }

    public static <T> Tuple2<T[], T[]> splitArray(T[] orig, int splitIndex) {
        return Tuple2.of(Arrays.copyOf(orig, splitIndex), Arrays.copyOfRange(orig, splitIndex, orig.length));
    }

    public static int[][] splitArray(int[] orig, int splitIndex) {
        int rightLength = orig.length - splitIndex;
        int[][] split = new int[][]{new int[splitIndex], new int[rightLength]};
        System.arraycopy(orig, 0, split[0], 0, splitIndex);
        System.arraycopy(orig, splitIndex, split[1], 0, rightLength);
        return split;
    }
}

