/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.oneOf;

import java.util.Objects;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.type.RuntimeTypes;

public class OneOf2<A, B> {
    private final Object item;
    private final int sel;
    private final ImList<Class> types;

    protected OneOf2(Object o, Class<A> aClass, Class<B> bClass, int index) {
        this.types = RuntimeTypes.registerClasses(aClass, bClass);
        this.sel = index;
        this.item = o;
        if (index < 0) {
            throw new IllegalArgumentException("Selected item index must be 0-1");
        }
        if (index > 1) {
            throw new IllegalArgumentException("Selected item index must be 0-1");
        }
        if (o != null && !((Class)this.types.get(index)).isInstance(o)) {
            throw new ClassCastException("You specified index " + index + ", indicating a(n) " + ((Class)this.types.get(index)).getCanonicalName() + ", but passed a " + o.getClass().getCanonicalName());
        }
    }

    public <R> R match(Fn1<A, R> fa, Fn1<B, R> fb) {
        if (this.sel == 0) {
            return fa.apply(this.item);
        }
        return fb.apply(this.item);
    }

    public int hashCode() {
        return Objects.hashCode(this.item) + this.sel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OneOf2)) {
            return false;
        }
        OneOf2 that = (OneOf2)other;
        return this.sel == that.sel && Objects.equals(this.item, that.item);
    }

    public String toString() {
        return RuntimeTypes.union2Str(this.item, this.types);
    }
}

