/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.rangedifferencer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.LCSSettings;
import org.eclipse.compare.rangedifferencer.DifferencesIterator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.OldDifferencer;
import org.eclipse.compare.rangedifferencer.RangeComparatorLCS;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class RangeDifferencer {
    private static final RangeDifference[] EMPTY_RESULT = new RangeDifference[0];

    private RangeDifferencer() {
    }

    public static RangeDifference[] findDifferences(LCSSettings lCSSettings, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2) {
        return RangeDifferencer.findDifferences((IProgressMonitor)null, lCSSettings, iRangeComparator, iRangeComparator2);
    }

    public static RangeDifference[] findDifferences(IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2) {
        return RangeDifferencer.findDifferences((IProgressMonitor)null, new LCSSettings(), iRangeComparator, iRangeComparator2);
    }

    public static RangeDifference[] findDifferences(IProgressMonitor iProgressMonitor, LCSSettings lCSSettings, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2) {
        if (!lCSSettings.isUseGreedyMethod()) {
            return OldDifferencer.findDifferences(iProgressMonitor, iRangeComparator, iRangeComparator2);
        }
        return RangeComparatorLCS.findDifferences(iProgressMonitor, lCSSettings, iRangeComparator, iRangeComparator2);
    }

    public static RangeDifference[] findDifferences(LCSSettings lCSSettings, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2, IRangeComparator iRangeComparator3) {
        return RangeDifferencer.findDifferences(null, lCSSettings, iRangeComparator, iRangeComparator2, iRangeComparator3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RangeDifference[] findDifferences(IProgressMonitor iProgressMonitor, LCSSettings lCSSettings, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2, IRangeComparator iRangeComparator3) {
        try {
            Object object;
            if (iRangeComparator == null) {
                RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(iProgressMonitor, lCSSettings, iRangeComparator2, iRangeComparator3);
                return rangeDifferenceArray;
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)CompareMessages.RangeComparatorLCS_0, (int)100);
            RangeDifference[] rangeDifferenceArray = null;
            RangeDifference[] rangeDifferenceArray2 = RangeDifferencer.findDifferences((IProgressMonitor)subMonitor.newChild(50), lCSSettings, iRangeComparator, iRangeComparator3);
            if (rangeDifferenceArray2 != null) {
                subMonitor.setWorkRemaining(100);
                rangeDifferenceArray = RangeDifferencer.findDifferences((IProgressMonitor)subMonitor.newChild(50), lCSSettings, iRangeComparator, iRangeComparator2);
            }
            if (rangeDifferenceArray2 == null || rangeDifferenceArray == null) {
                RangeDifference[] rangeDifferenceArray3 = null;
                return rangeDifferenceArray3;
            }
            DifferencesIterator differencesIterator = new DifferencesIterator(rangeDifferenceArray2);
            RangeDifference[] rangeDifferenceArray4 = new DifferencesIterator(rangeDifferenceArray);
            ArrayList<RangeDifference> arrayList = new ArrayList<RangeDifference>();
            arrayList.add(new RangeDifference(5));
            int n = 0;
            int n2 = 0;
            subMonitor.setWorkRemaining(rangeDifferenceArray2.length + rangeDifferenceArray.length);
            while (differencesIterator.fDifference != null || rangeDifferenceArray4.fDifference != null) {
                differencesIterator.removeAll();
                rangeDifferenceArray4.removeAll();
                object = differencesIterator.fDifference == null ? rangeDifferenceArray4 : (rangeDifferenceArray4.fDifference == null ? differencesIterator : (differencesIterator.fDifference.fLeftStart <= rangeDifferenceArray4.fDifference.fLeftStart ? differencesIterator : rangeDifferenceArray4));
                n = ((DifferencesIterator)object).fDifference.fLeftStart;
                n2 = ((DifferencesIterator)object).fDifference.leftEnd();
                ((DifferencesIterator)object).next();
                subMonitor.worked(1);
                DifferencesIterator differencesIterator2 = ((DifferencesIterator)object).other(differencesIterator, (DifferencesIterator)rangeDifferenceArray4);
                while (differencesIterator2.fDifference != null && differencesIterator2.fDifference.fLeftStart <= n2) {
                    int n3 = differencesIterator2.fDifference.leftEnd();
                    differencesIterator2.next();
                    subMonitor.worked(1);
                    if (n3 < n2) continue;
                    n2 = n3;
                    differencesIterator2 = differencesIterator2.other(differencesIterator, (DifferencesIterator)rangeDifferenceArray4);
                }
                arrayList.add(RangeDifferencer.createRangeDifference3(differencesIterator, (DifferencesIterator)rangeDifferenceArray4, arrayList, iRangeComparator3, iRangeComparator2, n, n2));
            }
            arrayList.remove(0);
            object = arrayList.toArray(EMPTY_RESULT);
            return object;
        }
        finally {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
        }
    }

    public static RangeDifference[] findRanges(LCSSettings lCSSettings, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2) {
        return RangeDifferencer.findRanges((IProgressMonitor)null, lCSSettings, iRangeComparator, iRangeComparator2);
    }

    public static RangeDifference[] findRanges(IProgressMonitor iProgressMonitor, LCSSettings lCSSettings, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2) {
        RangeDifference rangeDifference;
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(iProgressMonitor, lCSSettings, iRangeComparator, iRangeComparator2);
        ArrayList<RangeDifference> arrayList = new ArrayList<RangeDifference>();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rangeDifferenceArray.length; ++i) {
            RangeDifference rangeDifference2 = rangeDifferenceArray[i];
            rangeDifference = new RangeDifference(0, n, rangeDifference2.rightStart() - n, n2, rangeDifference2.leftStart() - n2);
            if (rangeDifference.maxLength() != 0) {
                arrayList.add(rangeDifference);
            }
            arrayList.add(rangeDifference2);
            n = rangeDifference2.rightEnd();
            n2 = rangeDifference2.leftEnd();
        }
        rangeDifference = new RangeDifference(0, n, iRangeComparator2.getRangeCount() - n, n2, iRangeComparator.getRangeCount() - n2);
        if (rangeDifference.maxLength() > 0) {
            arrayList.add(rangeDifference);
        }
        return arrayList.toArray(EMPTY_RESULT);
    }

    public static RangeDifference[] findRanges(LCSSettings lCSSettings, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2, IRangeComparator iRangeComparator3) {
        return RangeDifferencer.findRanges(null, lCSSettings, iRangeComparator, iRangeComparator2, iRangeComparator3);
    }

    public static RangeDifference[] findRanges(IProgressMonitor iProgressMonitor, LCSSettings lCSSettings, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2, IRangeComparator iRangeComparator3) {
        RangeDifference rangeDifference;
        if (iRangeComparator == null) {
            return RangeDifferencer.findRanges(iProgressMonitor, lCSSettings, iRangeComparator2, iRangeComparator3);
        }
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(iProgressMonitor, lCSSettings, iRangeComparator, iRangeComparator2, iRangeComparator3);
        ArrayList<RangeDifference> arrayList = new ArrayList<RangeDifference>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < rangeDifferenceArray.length; ++i) {
            RangeDifference rangeDifference2 = rangeDifferenceArray[i];
            rangeDifference = new RangeDifference(0, n, rangeDifference2.rightStart() - n, n2, rangeDifference2.leftStart() - n2, n3, rangeDifference2.ancestorStart() - n3);
            if (rangeDifference.maxLength() > 0) {
                arrayList.add(rangeDifference);
            }
            arrayList.add(rangeDifference2);
            n = rangeDifference2.rightEnd();
            n2 = rangeDifference2.leftEnd();
            n3 = rangeDifference2.ancestorEnd();
        }
        rangeDifference = new RangeDifference(0, n, iRangeComparator3.getRangeCount() - n, n2, iRangeComparator2.getRangeCount() - n2, n3, iRangeComparator.getRangeCount() - n3);
        if (rangeDifference.maxLength() > 0) {
            arrayList.add(rangeDifference);
        }
        return arrayList.toArray(EMPTY_RESULT);
    }

    private static RangeDifference createRangeDifference3(DifferencesIterator differencesIterator, DifferencesIterator differencesIterator2, List list, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2, int n, int n2) {
        int n3;
        int n4;
        RangeDifference rangeDifference;
        RangeDifference rangeDifference2;
        int n5;
        int n6;
        int n7 = 5;
        RangeDifference rangeDifference3 = (RangeDifference)list.get(list.size() - 1);
        Assert.isTrue((differencesIterator.getCount() != 0 || differencesIterator2.getCount() != 0 ? 1 : 0) != 0);
        if (differencesIterator.getCount() == 0) {
            n6 = n - rangeDifference3.ancestorEnd() + rangeDifference3.rightEnd();
            n5 = n2 - rangeDifference3.ancestorEnd() + rangeDifference3.rightEnd();
            n7 = 3;
        } else {
            rangeDifference2 = (RangeDifference)differencesIterator.fRange.get(0);
            rangeDifference = (RangeDifference)differencesIterator.fRange.get(differencesIterator.fRange.size() - 1);
            n6 = n - rangeDifference2.fLeftStart + rangeDifference2.fRightStart;
            n5 = n2 - rangeDifference.leftEnd() + rangeDifference.rightEnd();
        }
        if (differencesIterator2.getCount() == 0) {
            n4 = n - rangeDifference3.ancestorEnd() + rangeDifference3.leftEnd();
            n3 = n2 - rangeDifference3.ancestorEnd() + rangeDifference3.leftEnd();
            n7 = 2;
        } else {
            rangeDifference2 = (RangeDifference)differencesIterator2.fRange.get(0);
            rangeDifference = (RangeDifference)differencesIterator2.fRange.get(differencesIterator2.fRange.size() - 1);
            n4 = n - rangeDifference2.fLeftStart + rangeDifference2.fRightStart;
            n3 = n2 - rangeDifference.leftEnd() + rangeDifference.rightEnd();
        }
        if (n7 == 5) {
            n7 = RangeDifferencer.rangeSpansEqual(iRangeComparator, n6, n5 - n6, iRangeComparator2, n4, n3 - n4) ? 4 : 1;
        }
        return new RangeDifference(n7, n6, n5 - n6, n4, n3 - n4, n, n2 - n);
    }

    private static boolean rangeSpansEqual(IRangeComparator iRangeComparator, int n, int n2, IRangeComparator iRangeComparator2, int n3, int n4) {
        if (n2 == n4) {
            int n5 = 0;
            for (n5 = 0; n5 < n2 && RangeDifferencer.rangesEqual(iRangeComparator, n + n5, iRangeComparator2, n3 + n5); ++n5) {
            }
            if (n5 == n2) {
                return true;
            }
        }
        return false;
    }

    private static boolean rangesEqual(IRangeComparator iRangeComparator, int n, IRangeComparator iRangeComparator2, int n2) {
        return iRangeComparator.rangesEqual(n, iRangeComparator2, n2);
    }
}

