/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.generic;

import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.util.InputStreamForker;
import org.ow2.easywsdl.wsdl.util.WSDLVersionDetector;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WSDLReaderImpl
extends AbstractWSDLReaderImpl
implements WSDLReader {
    private final AbstractWSDLReaderImpl reader11 = new org.ow2.easywsdl.wsdl.impl.wsdl11.WSDLReaderImpl();
    private final AbstractWSDLReaderImpl reader20 = new org.ow2.easywsdl.wsdl.impl.wsdl20.WSDLReaderImpl();

    @Override
    public Description read(URL wsdlURL) throws WSDLException, MalformedURLException, IOException, URISyntaxException {
        try (InputStream is = wsdlURL.openStream();){
            InputSource inputSource = new InputSource();
            inputSource.setSystemId(wsdlURL.toString());
            AbsItfDescription.WSDLVersionConstants version = WSDLVersionDetector.getVersion(inputSource);
            inputSource = new InputSource(wsdlURL.openStream());
            inputSource.setSystemId(wsdlURL.toString());
            Description description = this.read(version, inputSource, new HashMap<URI, AbsItfDescription>(), new HashMap<URI, AbsItfSchema>());
            return description;
        }
    }

    @Override
    public Description read(InputSource inputSource, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports) throws WSDLException, MalformedURLException, URISyntaxException {
        if (inputSource.getByteStream() != null) {
            String systemId = inputSource.getSystemId();
            if (systemId != null) {
                this.setDocumentBaseURI(new URI(systemId));
            }
            InputStream originalInputStream = inputSource.getByteStream();
            InputStreamForker isf = new InputStreamForker(originalInputStream);
            inputSource.setByteStream(isf.getInputStreamOne());
            AbsItfDescription.WSDLVersionConstants version = null;
            try {
                DOMSource source = SourceHelper.toDOMSource((InputSource)inputSource);
                version = WSDLVersionDetector.getVersion((Document)source.getNode());
            }
            catch (IOException e) {
                throw new WSDLException(e);
            }
            inputSource.setByteStream(isf.getInputStreamTwo());
            return this.read(version, inputSource, descriptionImports, schemaImports);
        }
        throw new UnsupportedOperationException("This method supports only InputSource with byte stream.");
    }

    private Description read(AbsItfDescription.WSDLVersionConstants version, InputSource source, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports) throws WSDLException, MalformedURLException, URISyntaxException {
        AbstractWSDLReaderImpl reader;
        if (version == AbsItfDescription.WSDLVersionConstants.WSDL11) {
            reader = this.reader11;
        } else if (version == AbsItfDescription.WSDLVersionConstants.WSDL20) {
            reader = this.reader20;
        } else {
            throw new WSDLException("unknown version of wsdl");
        }
        reader.setFeatures(this.getFeatures());
        return reader.read(source, descriptionImports, schemaImports);
    }

    @Override
    public Description read(Document document) throws WSDLException, URISyntaxException {
        AbsItfDescription.WSDLVersionConstants version = WSDLVersionDetector.getVersion(document);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(new DOMSource(document), streamResult);
            baos.flush();
            baos.close();
            InputSource documentInputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
            documentInputSource.setSystemId(document.getBaseURI());
            Description description = this.read(version, documentInputSource, null, new HashMap<URI, AbsItfSchema>());
            return description;
        }
        catch (TransformerException e) {
            throw new WSDLException(e);
        }
        catch (IOException e) {
            throw new WSDLException(e);
        }
        finally {
            if (transformer != null) {
                Transformers.releaseTransformer((Transformer)transformer);
            }
        }
    }

    @Override
    public Description read(InputSource inputSource) throws WSDLException, MalformedURLException, URISyntaxException {
        return this.read(inputSource, new HashMap<URI, AbsItfDescription>(), new HashMap<URI, AbsItfSchema>());
    }
}

