/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.wsdl11;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.WSDLJAXBContext;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDefinitions;
import org.ow2.easywsdl.wsdl.util.CustomPrefixMapper;
import org.ow2.easywsdl.wsdl.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSDLWriterImpl
implements WSDLWriter {
    private final DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();

    public WSDLWriterImpl() throws WSDLException {
        this.builder.setNamespaceAware(true);
    }

    private final Marshaller createMarshaller(Description wsdlDef, String schemaLocation) throws WSDLException {
        try {
            Marshaller marshaller = WSDLJAXBContext.getJaxbContext().createMarshaller();
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new CustomPrefixMapper(wsdlDef.getNamespaces().getPreDeclaredNamespaceUris()));
            if (schemaLocation != null) {
                marshaller.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
            }
            return marshaller;
        }
        catch (JAXBException je) {
            throw new WSDLException(je);
        }
    }

    public Document convertWSDL11Definition2DOMElement(Description wsdlDef, String schemaLocation) throws WSDLException {
        TDefinitions wsdlDescriptor = (TDefinitions)((DescriptionImpl)wsdlDef).getModel();
        Document doc = null;
        try {
            doc = this.builder.newDocumentBuilder().newDocument();
            JAXBElement element = new JAXBElement(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"), wsdlDescriptor.getClass(), (Object)wsdlDescriptor);
            Marshaller marshaller = this.createMarshaller(wsdlDef, schemaLocation);
            marshaller.marshal((Object)element, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new WSDLException("Failed to build XML binding from WSDL descriptor Java classes", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new WSDLException("Failed to build XML binding from WSDL descriptor Java classes", ex);
        }
        return doc;
    }

    public String convertWSDL11Definition2String(Description wsdlDef, String schemaLocation) throws WSDLException {
        TDefinitions wsdlDescriptor = (TDefinitions)((DescriptionImpl)wsdlDef).getModel();
        try {
            StringWriter stringWriter = new StringWriter();
            JAXBElement element = new JAXBElement(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"), wsdlDescriptor.getClass(), (Object)wsdlDescriptor);
            Marshaller marshaller = this.createMarshaller(wsdlDef, schemaLocation);
            marshaller.marshal((Object)element, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new WSDLException("Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }

    private static final void appendMissingOriginalNamespaceDeclarations(Description wsdlDef, Document doc) {
        for (Map.Entry namespaceDefinition : wsdlDef.getNamespaces().getNamespaces().entrySet()) {
            String namespacePrefix = (String)namespaceDefinition.getKey();
            String namespaceURI = (String)namespaceDefinition.getValue();
            if (doc.lookupNamespaceURI(namespacePrefix) != null) continue;
            doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespacePrefix, namespaceURI);
        }
    }

    @Override
    public Document getDocument(Description wsdlDef) throws WSDLException {
        Document doc = null;
        if (wsdlDef != null && wsdlDef instanceof DescriptionImpl) {
            try {
                String schemaLocation = Util.convertSchemaLocationIntoString(wsdlDef);
                doc = this.convertWSDL11Definition2DOMElement(wsdlDef, schemaLocation);
                if (wsdlDef.getDocumentBaseURI() != null) {
                    doc.setDocumentURI(wsdlDef.getDocumentBaseURI().toString());
                } else {
                    doc.setDocumentURI(".");
                }
                WSDLWriterImpl.appendMissingOriginalNamespaceDeclarations(wsdlDef, doc);
            }
            catch (WSDLException e) {
                throw new WSDLException("Can not write wsdl description", (Throwable)((Object)e));
            }
        }
        return doc;
    }

    @Override
    public boolean getFeature(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String writeWSDL(Description wsdlDef) throws WSDLException {
        String res = null;
        if (wsdlDef != null && wsdlDef instanceof DescriptionImpl) {
            try {
                String schemaLocation = Util.convertSchemaLocationIntoString(wsdlDef);
                res = this.convertWSDL11Definition2String(wsdlDef, schemaLocation);
            }
            catch (WSDLException e) {
                throw new WSDLException("Can not write wsdl description", (Throwable)((Object)e));
            }
        }
        return res;
    }
}

