/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard;

import java.io.IOException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.csrfguard.CsrfValidator;
import org.owasp.csrfguard.action.IAction;
import org.owasp.csrfguard.config.ConfigurationProvider;
import org.owasp.csrfguard.config.ConfigurationProviderFactory;
import org.owasp.csrfguard.config.NullConfigurationProvider;
import org.owasp.csrfguard.config.PropertiesConfigurationProviderFactory;
import org.owasp.csrfguard.config.overlay.ExpirableCache;
import org.owasp.csrfguard.session.LogicalSession;
import org.owasp.csrfguard.token.service.TokenService;
import org.owasp.csrfguard.token.storage.LogicalSessionExtractor;
import org.owasp.csrfguard.token.storage.TokenHolder;
import org.owasp.csrfguard.util.CsrfGuardPropertiesToStringBuilder;
import org.owasp.csrfguard.util.CsrfGuardUtils;

public final class CsrfGuard {
    private static final ExpirableCache<Boolean, ConfigurationProvider> configurationProviderExpirableCache = new ExpirableCache(1);
    private final Map<String, Pattern> regexPatternCache = new ConcurrentHashMap<String, Pattern>();
    private Properties properties = null;
    private boolean isJavaScriptConfigurationNeeded;

    private CsrfGuard() {
    }

    public static CsrfGuard getInstance() {
        return SingletonHolder.instance;
    }

    public static void load(Properties theProperties) {
        CsrfGuard.getInstance().properties = theProperties;
        configurationProviderExpirableCache.clear();
    }

    public Map<String, Pattern> getRegexPatternCache() {
        return this.regexPatternCache;
    }

    public String getTokenName() {
        return this.config().getTokenName();
    }

    public int getTokenLength() {
        return this.config().getTokenLength();
    }

    public boolean isRotateEnabled() {
        return this.config().isRotateEnabled();
    }

    public boolean isTokenPerPageEnabled() {
        return this.config().isTokenPerPageEnabled();
    }

    public boolean isTokenPerPagePrecreate() {
        return this.config().isTokenPerPagePrecreateEnabled();
    }

    public boolean isValidateWhenNoSessionExists() {
        return this.config().isValidateWhenNoSessionExists();
    }

    public SecureRandom getPrng() {
        return this.config().getPrng();
    }

    public String getNewTokenLandingPage() {
        return this.config().getNewTokenLandingPage();
    }

    public boolean isUseNewTokenLandingPage() {
        return this.config().isUseNewTokenLandingPage();
    }

    public boolean isAjaxEnabled() {
        return this.config().isAjaxEnabled();
    }

    public boolean isForceSynchronousAjax() {
        return this.config().isForceSynchronousAjax();
    }

    public boolean isProtectEnabled() {
        return this.config().isProtectEnabled();
    }

    public boolean isEnabled() {
        return this.config().isEnabled();
    }

    public Set<String> getProtectedPages() {
        return this.config().getProtectedPages();
    }

    public Set<String> getUnprotectedPages() {
        return this.config().getUnprotectedPages();
    }

    public TokenHolder getTokenHolder() {
        return this.config().getTokenHolder();
    }

    public LogicalSessionExtractor getLogicalSessionExtractor() {
        return this.config().getLogicalSessionExtractor();
    }

    public Set<String> getProtectedMethods() {
        return this.config().getProtectedMethods();
    }

    public List<IAction> getActions() {
        return this.config().getActions();
    }

    public void initializeJavaScriptConfiguration() {
        this.config().initializeJavaScriptConfiguration();
        this.isJavaScriptConfigurationNeeded = true;
    }

    public boolean isJavascriptInjectFormAttributes() {
        return this.config().isJavascriptInjectFormAttributes();
    }

    public boolean isJavascriptInjectGetForms() {
        return this.config().isJavascriptInjectGetForms();
    }

    public boolean isJavascriptDomainStrict() {
        return this.config().isJavascriptDomainStrict();
    }

    public boolean isJavascriptRefererMatchProtocol() {
        return this.config().isJavascriptRefererMatchProtocol();
    }

    public boolean isJavascriptRefererMatchDomain() {
        return this.config().isJavascriptRefererMatchDomain();
    }

    public String getJavascriptCacheControl() {
        return this.config().getJavascriptCacheControl();
    }

    public String getJavascriptTaggedCacheControl() {
        return this.config().getJavascriptTaggedCacheControl();
    }

    public Pattern getJavascriptRefererPattern() {
        return this.config().getJavascriptRefererPattern();
    }

    public boolean isJavascriptInjectIntoForms() {
        return this.config().isJavascriptInjectIntoForms();
    }

    public boolean isJavascriptInjectIntoAttributes() {
        return this.config().isJavascriptInjectIntoAttributes();
    }

    public boolean isJavascriptInjectIntoDynamicallyCreatedNodes() {
        return this.config().isJavascriptInjectIntoDynamicallyCreatedNodes();
    }

    public String getJavascriptDynamicNodeCreationEventName() {
        return this.config().getJavascriptDynamicNodeCreationEventName();
    }

    public String getJavascriptXrequestedWith() {
        return this.config().getJavascriptXrequestedWith();
    }

    public String getJavascriptTemplateCode() {
        return this.config().getJavascriptTemplateCode();
    }

    public String getJavascriptUnprotectedExtensions() {
        return this.config().getJavascriptUnprotectedExtensions();
    }

    public TokenService getTokenService() {
        return new TokenService(this);
    }

    public boolean isPrintConfig() {
        return this.config().isPrintConfig();
    }

    public String getDomainOrigin() {
        return this.config().getDomainOrigin();
    }

    public Duration getPageTokenSynchronizationTolerance() {
        return this.config().getPageTokenSynchronizationTolerance();
    }

    public Set<String> getUnprotectedMethods() {
        return this.config().getUnprotectedMethods();
    }

    public Set<String> getBannedUserAgentProperties() {
        return this.config().getBannedUserAgentProperties();
    }

    public String toString() {
        return this.isEnabled() ? new CsrfGuardPropertiesToStringBuilder(this.config()).toString() : "OWASP CSRFGuard is disabled.";
    }

    public boolean isRotateEnabled(HttpServletRequest request) {
        return this.isRotateEnabled() && !CsrfGuardUtils.isAjaxRequest(request);
    }

    public void onSessionCreated(LogicalSession logicalSession) {
        if (this.isEnabled()) {
            String logicalSessionKey = logicalSession.getKey();
            TokenService tokenService = this.getTokenService();
            tokenService.createMasterTokenIfAbsent(logicalSessionKey);
            if (this.isTokenPerPageEnabled() && this.isTokenPerPagePrecreate() && this.isProtectEnabled() && !logicalSession.areTokensGenerated()) {
                tokenService.generateProtectedPageTokens(logicalSessionKey);
                logicalSession.setTokensGenerated(true);
            }
        }
    }

    public void onSessionDestroyed(LogicalSession logicalSession) {
        TokenHolder tokenHolder = this.getTokenHolder();
        if (Objects.nonNull(tokenHolder)) {
            tokenHolder.remove(logicalSession.getKey());
        }
    }

    public void writeLandingPage(HttpServletResponse response, String logicalSessionKey) throws IOException {
        String landingPage = this.getNewTokenLandingPage();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>").append("<head>").append("<title>OWASP CSRFGuard Project - New Token Landing Page</title>").append("</head>").append("<body>").append("<script type=\"text/javascript\">").append("var form = document.createElement(\"form\");").append("form.setAttribute(\"method\", \"post\");").append(String.format("form.setAttribute(\"action\", \"%s\");", landingPage));
        if (new CsrfValidator().isProtectedPage(landingPage).isProtected()) {
            stringBuilder.append("var hiddenField = document.createElement(\"input\");").append("hiddenField.setAttribute(\"type\", \"hidden\");").append(String.format("hiddenField.setAttribute(\"name\", \"%s\");", this.getTokenName())).append(String.format("hiddenField.setAttribute(\"value\", \"%s\");", this.getTokenService().getTokenValue(logicalSessionKey, landingPage))).append("form.appendChild(hiddenField);");
        }
        stringBuilder.append("document.body.appendChild(form);").append("form.submit();").append("</script>").append("</body>").append("</html>");
        String code = stringBuilder.toString();
        response.setContentType("text/html");
        response.setContentLength(code.length());
        response.getWriter().write(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationProvider config() {
        if (this.properties == null) {
            return new NullConfigurationProvider();
        }
        ConfigurationProvider configurationProvider = configurationProviderExpirableCache.get(Boolean.TRUE);
        if (configurationProvider == null) {
            Class<CsrfGuard> clazz = CsrfGuard.class;
            synchronized (CsrfGuard.class) {
                configurationProvider = this.retrieveNewConfig();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (!configurationProvider.isCacheable()) {
            configurationProvider = this.retrieveNewConfig();
        }
        return configurationProvider;
    }

    private ConfigurationProvider retrieveNewConfig() {
        String configurationProviderFactoryClassName = this.properties.getProperty("org.owasp.csrfguard.configuration.provider.factory", PropertiesConfigurationProviderFactory.class.getName());
        Class configurationProviderFactoryClass = CsrfGuardUtils.forName(configurationProviderFactoryClassName);
        ConfigurationProviderFactory configurationProviderFactory = (ConfigurationProviderFactory)CsrfGuardUtils.newInstance(configurationProviderFactoryClass);
        ConfigurationProvider configurationProvider = configurationProviderFactory.retrieveConfiguration(this.properties);
        if (this.isJavaScriptConfigurationNeeded) {
            configurationProvider.initializeJavaScriptConfiguration();
        }
        configurationProviderExpirableCache.put(Boolean.TRUE, configurationProvider);
        return configurationProvider;
    }

    private static final class SingletonHolder {
        public static final CsrfGuard instance = new CsrfGuard();

        private SingletonHolder() {
        }
    }
}

