/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class VersionFilterAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionFilterAnalyzer.class);
    private static final String FILE = "file";
    private static final String POM = "pom";
    private static final String NEXUS = "nexus";
    private static final String CENTRAL = "central";
    private static final String MANIFEST = "Manifest";
    private static final String VERSION = "version";
    private static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String ANALYZER_NAME = "Version Filter Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_INFORMATION_COLLECTION3;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.versionfilter.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        DependencyVersion version;
        Set evidence;
        Evidence e2;
        Set<Object> remove;
        if (dependency.getVersion() != null) {
            remove = dependency.getEvidence(EvidenceType.VERSION).stream().filter(e -> !e.isFromHint() && !dependency.getVersion().equals(e.getValue())).collect(Collectors.toSet());
        } else {
            remove = new HashSet();
            String fileVersion = null;
            String pomVersion = null;
            String manifestVersion = null;
            for (Evidence e3 : dependency.getEvidence(EvidenceType.VERSION)) {
                if (FILE.equals(e3.getSource()) && VERSION.equals(e3.getName())) {
                    fileVersion = e3.getValue();
                    continue;
                }
                if ((NEXUS.equals(e3.getSource()) || CENTRAL.equals(e3.getSource()) || POM.equals(e3.getSource())) && VERSION.equals(e3.getName())) {
                    pomVersion = e3.getValue();
                    continue;
                }
                if (!MANIFEST.equals(e3.getSource()) || !IMPLEMENTATION_VERSION.equals(e3.getName())) continue;
                manifestVersion = e3.getValue();
            }
            if ((fileVersion == null ? 0 : 1) + (pomVersion == null ? 0 : 1) + (manifestVersion == null ? 0 : 1) > 1) {
                boolean pomMatch;
                DependencyVersion dvFile = new DependencyVersion(fileVersion);
                DependencyVersion dvPom = new DependencyVersion(pomVersion);
                DependencyVersion dvManifest = new DependencyVersion(manifestVersion);
                boolean fileMatch = Objects.equals(dvFile, dvPom) || Objects.equals(dvFile, dvManifest);
                boolean manifestMatch = Objects.equals(dvManifest, dvPom) || Objects.equals(dvManifest, dvFile);
                boolean bl = pomMatch = Objects.equals(dvPom, dvFile) || Objects.equals(dvPom, dvManifest);
                if (fileMatch || manifestMatch || pomMatch) {
                    LOGGER.debug("filtering evidence from {}", (Object)dependency.getFileName());
                    for (Evidence e4 : dependency.getEvidence(EvidenceType.VERSION)) {
                        if (e4.isFromHint() || pomMatch && VERSION.equals(e4.getName()) && (NEXUS.equals(e4.getSource()) || CENTRAL.equals(e4.getSource()) || POM.equals(e4.getSource())) || fileMatch && VERSION.equals(e4.getName()) && FILE.equals(e4.getSource()) || manifestMatch && MANIFEST.equals(e4.getSource()) && IMPLEMENTATION_VERSION.equals(e4.getName())) continue;
                        remove.add(e4);
                    }
                }
            }
        }
        remove.forEach(e -> dependency.removeEvidence(EvidenceType.VERSION, (Evidence)e));
        if (dependency.getVersion() == null && (e2 = (Evidence)(evidence = dependency.getEvidence(EvidenceType.VERSION)).stream().findFirst().orElse(null)) != null && (version = DependencyVersionUtil.parseVersion(e2.getValue(), true)) != null) {
            if (evidence.stream().map(ev -> DependencyVersionUtil.parseVersion(ev.getValue(), true)).allMatch(version::equals)) {
                dependency.setVersion(version.toString());
            }
        }
    }
}

