/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import java.io.File;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.analyzer.AbstractDependencyComparingAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.DependencyMergingAnalyzer;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.semver4j.Semver;
import org.semver4j.SemverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DependencyBundlingAnalyzer
extends AbstractDependencyComparingAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyBundlingAnalyzer.class);
    private static final Pattern STARTING_TEXT_PATTERN = Pattern.compile("^[a-zA-Z0-9]*");
    private static final String ANALYZER_NAME = "Dependency Bundling Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.FINAL;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.dependencybundling.enabled";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean evaluateDependencies(Dependency dependency, Dependency nextDependency, Set<Dependency> dependenciesToRemove) {
        if (this.hashesMatch(dependency, nextDependency)) {
            if (this.containedInWar(dependency.getFilePath())) return false;
            if (this.containedInWar(nextDependency.getFilePath())) return false;
            if (DependencyBundlingAnalyzer.firstPathIsShortest(dependency.getFilePath(), nextDependency.getFilePath())) {
                DependencyBundlingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                return false;
            }
            DependencyBundlingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
            return true;
        }
        if (this.isShadedJar(dependency, nextDependency)) {
            if (dependency.getFileName().toLowerCase().endsWith("pom.xml")) {
                DependencyBundlingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
                nextDependency.removeRelatedDependencies(dependency);
                return true;
            }
            DependencyBundlingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
            dependency.removeRelatedDependencies(nextDependency);
            return false;
        }
        if (this.isWebJar(dependency, nextDependency)) {
            if (dependency.getFileName().toLowerCase().endsWith(".js")) {
                DependencyBundlingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove, true);
                nextDependency.removeRelatedDependencies(dependency);
                return true;
            }
            DependencyBundlingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove, true);
            dependency.removeRelatedDependencies(nextDependency);
            return false;
        }
        if (this.cpeIdentifiersMatch(dependency, nextDependency) && this.hasSameBasePath(dependency, nextDependency) && this.vulnerabilitiesMatch(dependency, nextDependency) && this.fileNameMatch(dependency, nextDependency)) {
            if (this.isCore(dependency, nextDependency)) {
                DependencyBundlingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                return false;
            }
            DependencyBundlingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
            return true;
        }
        if (!this.ecosystemIs("nodejs", dependency, nextDependency)) return false;
        if (!this.namesAreEqual(dependency, nextDependency)) return false;
        if (!DependencyBundlingAnalyzer.npmVersionsMatch(dependency.getVersion(), nextDependency.getVersion())) return false;
        if (!dependency.isVirtual()) {
            DependencyMergingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
            return false;
        }
        DependencyMergingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
        return true;
    }

    public static void mergeDependencies(Dependency dependency, Dependency relatedDependency, Set<Dependency> dependenciesToRemove) {
        DependencyBundlingAnalyzer.mergeDependencies(dependency, relatedDependency, dependenciesToRemove, false);
    }

    public static void mergeDependencies(Dependency dependency, Dependency relatedDependency, Set<Dependency> dependenciesToRemove, boolean copyVulnsAndIds) {
        dependency.addRelatedDependency(relatedDependency);
        relatedDependency.getRelatedDependencies().forEach(dependency::addRelatedDependency);
        relatedDependency.clearRelatedDependencies();
        if (copyVulnsAndIds) {
            relatedDependency.getSoftwareIdentifiers().forEach(dependency::addSoftwareIdentifier);
            relatedDependency.getVulnerableSoftwareIdentifiers().forEach(dependency::addVulnerableSoftwareIdentifier);
            relatedDependency.getVulnerabilities().forEach(dependency::addVulnerability);
        }
        if (dependency.getSha1sum() != null && dependency.getSha1sum().equals(relatedDependency.getSha1sum())) {
            dependency.addAllProjectReferences(relatedDependency.getProjectReferences());
            dependency.addAllIncludedBy(relatedDependency.getIncludedBy());
        }
        if (dependenciesToRemove != null) {
            dependenciesToRemove.add(relatedDependency);
        }
    }

    private String getBaseRepoPath(String path, String repo) {
        int pos = path.indexOf(repo + File.separator) + repo.length() + 1;
        if (pos < repo.length() + 1) {
            return path;
        }
        int tmp = path.indexOf(File.separator, pos);
        if (tmp <= 0) {
            return path;
        }
        pos = tmp + 1;
        if ((tmp = path.indexOf(File.separator, pos)) > 0) {
            pos = tmp + 1;
        }
        return path.substring(0, pos);
    }

    private boolean fileNameMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency1.getFileName() == null || dependency2 == null || dependency2.getFileName() == null) {
            return false;
        }
        String fileName1 = dependency1.getActualFile().getName();
        String fileName2 = dependency2.getActualFile().getName();
        DependencyVersion version1 = DependencyVersionUtil.parseVersion(fileName1);
        DependencyVersion version2 = DependencyVersionUtil.parseVersion(fileName2);
        if (version1 != null && version2 != null && !version1.equals(version2)) {
            return false;
        }
        Matcher match1 = STARTING_TEXT_PATTERN.matcher(fileName1);
        Matcher match2 = STARTING_TEXT_PATTERN.matcher(fileName2);
        if (match1.find() && match2.find()) {
            return match1.group().equals(match2.group());
        }
        return false;
    }

    private boolean cpeIdentifiersMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency1.getVulnerableSoftwareIdentifiers() == null || dependency2 == null || dependency2.getVulnerableSoftwareIdentifiers() == null) {
            return false;
        }
        boolean matches = false;
        int cpeCount1 = dependency1.getVulnerableSoftwareIdentifiers().size();
        int cpeCount2 = dependency2.getVulnerableSoftwareIdentifiers().size();
        if (cpeCount1 > 0 && cpeCount1 == cpeCount2) {
            for (Identifier i : dependency1.getVulnerableSoftwareIdentifiers()) {
                if (matches |= dependency2.getVulnerableSoftwareIdentifiers().contains(i)) continue;
                break;
            }
        }
        LOGGER.trace("IdentifiersMatch={} ({}, {})", new Object[]{matches, dependency1.getFileName(), dependency2.getFileName()});
        return matches;
    }

    private boolean vulnerabilitiesMatch(Dependency dependency1, Dependency dependency2) {
        Set<Vulnerability> one = dependency1.getVulnerabilities();
        Set<Vulnerability> two = dependency2.getVulnerabilities();
        return one != null && two != null && one.size() == two.size() && one.containsAll(two);
    }

    private boolean hasSameBasePath(Dependency dependency1, Dependency dependency2) {
        Pattern p;
        if (dependency1 == null || dependency2 == null) {
            return false;
        }
        File lFile = new File(dependency1.getFilePath());
        String left = lFile.getParent();
        File rFile = new File(dependency2.getFilePath());
        String right = rFile.getParent();
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        if (left.equalsIgnoreCase(right)) {
            return true;
        }
        String localRepo = this.getSettings().getString("odc.maven.local.repo");
        if (localRepo == null) {
            p = Pattern.compile(".*[/\\\\](?<repo>repository|local-repo)[/\\\\].*");
        } else {
            File f = new File(localRepo);
            String dir = f.getName();
            p = Pattern.compile(".*[/\\\\](?<repo>repository|local-repo|" + Pattern.quote(dir) + ")[/\\\\].*");
        }
        Matcher mleft = p.matcher(left);
        Matcher mright = p.matcher(right);
        if (mleft.find() && mright.find()) {
            left = this.getBaseRepoPath(left, mleft.group("repo"));
            right = this.getBaseRepoPath(right, mright.group("repo"));
        }
        if (left.equalsIgnoreCase(right)) {
            return true;
        }
        for (Dependency child : dependency2.getRelatedDependencies()) {
            if (!this.hasSameBasePath(child, dependency1)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCore(Dependency left, Dependency right) {
        String leftName = left.getFileName().toLowerCase();
        String rightName = right.getFileName().toLowerCase();
        boolean returnVal = left.isVirtual() && !right.isVirtual() ? true : (!left.isVirtual() && right.isVirtual() ? false : (!rightName.matches(".*\\.(tar|tgz|gz|zip|ear|war|rpm).+") && leftName.matches(".*\\.(tar|tgz|gz|zip|ear|war|rpm).+") || rightName.contains("core") && !leftName.contains("core") || rightName.contains("kernel") && !leftName.contains("kernel") || rightName.contains("server") && !leftName.contains("server") || rightName.contains("project") && !leftName.contains("project") || rightName.contains("engine") && !leftName.contains("engine") || rightName.contains("akka-stream") && !leftName.contains("akka-stream") || rightName.contains("netty-transport") && !leftName.contains("netty-transport") ? false : (rightName.matches(".*\\.(tar|tgz|gz|zip|ear|war|rpm).+") && !leftName.matches(".*\\.(tar|tgz|gz|zip|ear|war|rpm).+") || !rightName.contains("core") && leftName.contains("core") || !rightName.contains("kernel") && leftName.contains("kernel") || !rightName.contains("server") && leftName.contains("server") || !rightName.contains("project") && leftName.contains("project") || !rightName.contains("engine") && leftName.contains("engine") || !rightName.contains("akka-stream") && leftName.contains("akka-stream") || !rightName.contains("netty-transport") && leftName.contains("netty-transport") ? true : leftName.length() <= rightName.length())));
        LOGGER.debug("IsCore={} ({}, {})", new Object[]{returnVal, left.getFileName(), right.getFileName()});
        return returnVal;
    }

    private boolean hashesMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null || dependency1.getSha1sum() == null || dependency2.getSha1sum() == null) {
            return false;
        }
        return dependency1.getSha1sum().equals(dependency2.getSha1sum());
    }

    protected boolean isWebJar(Dependency dependency, Dependency nextDependency) {
        if (dependency == null || dependency.getFileName() == null || nextDependency == null || nextDependency.getFileName() == null || dependency.getSoftwareIdentifiers().isEmpty() || nextDependency.getSoftwareIdentifiers().isEmpty()) {
            return false;
        }
        String mainName = dependency.getFileName().toLowerCase();
        String nextName = nextDependency.getFileName().toLowerCase();
        if (mainName.endsWith(".jar") && nextName.endsWith(".js") && nextName.startsWith(mainName)) {
            return dependency.getSoftwareIdentifiers().stream().map(Identifier::getValue).collect(Collectors.toSet()).containsAll(nextDependency.getSoftwareIdentifiers().stream().map(this::identifierToWebJarForComparison).collect(Collectors.toSet()));
        }
        if (nextName.endsWith(".jar") && mainName.endsWith("js") && mainName.startsWith(nextName)) {
            return nextDependency.getSoftwareIdentifiers().stream().map(Identifier::getValue).collect(Collectors.toSet()).containsAll(dependency.getSoftwareIdentifiers().stream().map(this::identifierToWebJarForComparison).collect(Collectors.toSet()));
        }
        return false;
    }

    private String identifierToWebJarForComparison(Identifier id) {
        if (id instanceof PurlIdentifier) {
            PurlIdentifier pid = (PurlIdentifier)id;
            try {
                PurlIdentifier nid = new PurlIdentifier("maven", "org.webjars", pid.getName(), pid.getVersion(), pid.getConfidence());
                return nid.getValue();
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to build webjar purl id", (Throwable)ex);
                return id.getValue();
            }
        }
        return id == null ? "" : id.getValue();
    }

    protected boolean isShadedJar(Dependency dependency, Dependency nextDependency) {
        if (dependency == null || dependency.getFileName() == null || nextDependency == null || nextDependency.getFileName() == null || dependency.getSoftwareIdentifiers().isEmpty() || nextDependency.getSoftwareIdentifiers().isEmpty()) {
            return false;
        }
        String mainName = dependency.getFileName().toLowerCase();
        String nextName = nextDependency.getFileName().toLowerCase();
        if (mainName.endsWith(".jar") && nextName.endsWith("pom.xml")) {
            return dependency.getSoftwareIdentifiers().containsAll(nextDependency.getSoftwareIdentifiers());
        }
        if (nextName.endsWith(".jar") && mainName.endsWith("pom.xml")) {
            return nextDependency.getSoftwareIdentifiers().containsAll(dependency.getSoftwareIdentifiers());
        }
        return false;
    }

    public static boolean firstPathIsShortest(String left, String right) {
        int rightCount;
        if (left.contains("dctemp") && !right.contains("dctemp")) {
            return false;
        }
        String leftPath = left.replace('\\', '/');
        String rightPath = right.replace('\\', '/');
        int leftCount = DependencyBundlingAnalyzer.countChar(leftPath, '/');
        if (leftCount == (rightCount = DependencyBundlingAnalyzer.countChar(rightPath, '/'))) {
            return leftPath.compareTo(rightPath) <= 0;
        }
        return leftCount < rightCount;
    }

    private static int countChar(String string, char c) {
        int count = 0;
        int max = string.length();
        for (int i = 0; i < max; ++i) {
            if (c != string.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    private boolean containedInWar(String filePath) {
        return filePath != null && filePath.matches(".*\\.(ear|war)[\\\\/].*");
    }

    private boolean ecosystemIs(String ecoSystem, Dependency dependency, Dependency nextDependency) {
        return ecoSystem.equals(dependency.getEcosystem()) && ecoSystem.equals(nextDependency.getEcosystem());
    }

    private boolean namesAreEqual(Dependency dependency, Dependency nextDependency) {
        return dependency.getName() != null && dependency.getName().equals(nextDependency.getName());
    }

    public static boolean npmVersionsMatch(String current, String next) {
        String left = current;
        String right = next;
        if (left == null || right == null) {
            return false;
        }
        if (left.equals(right) || "*".equals(left) || "*".equals(right)) {
            return true;
        }
        if (left.contains(" ")) {
            if (right.contains(" ")) {
                return false;
            }
            if (!right.matches("^\\d.*$") && (right = DependencyBundlingAnalyzer.stripLeadingNonNumeric(right)) == null) {
                return false;
            }
            try {
                Semver v = new Semver(right);
                return v.satisfies(left);
            }
            catch (SemverException ex) {
                LOGGER.trace("ignore", (Throwable)ex);
            }
        } else {
            if (!left.matches("^\\d.*$") && ((left = DependencyBundlingAnalyzer.stripLeadingNonNumeric(left)) == null || left.isEmpty())) {
                return false;
            }
            try {
                Semver v = new Semver(left);
                if (!right.isEmpty() && v.satisfies(right)) {
                    return true;
                }
                if (!right.contains(" ")) {
                    left = current;
                    if ((right = DependencyBundlingAnalyzer.stripLeadingNonNumeric(right)) != null) {
                        v = new Semver(right);
                        return v.satisfies(left);
                    }
                }
            }
            catch (SemverException ex) {
                LOGGER.trace("ignore", (Throwable)ex);
            }
            catch (NullPointerException ex) {
                LOGGER.error("SemVer comparison error: left:\"{}\", right:\"{}\"", (Object)left, (Object)right);
                LOGGER.debug("SemVer comparison resulted in NPE", (Throwable)ex);
            }
        }
        return false;
    }

    private static String stripLeadingNonNumeric(String str) {
        for (int x = 0; x < str.length(); ++x) {
            if (!Character.isDigit(str.codePointAt(x))) continue;
            return str.substring(x);
        }
        return null;
    }
}

