/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalDataSource
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDataSource.class);

    protected void saveLastUpdated(File repo, long timestamp) {
        File timestampFile = new File(String.valueOf(repo) + ".properties");
        try (FileOutputStream out = new FileOutputStream(timestampFile);){
            Properties prop = new Properties();
            prop.setProperty("LAST_UPDATED", String.valueOf(timestamp));
            prop.store(out, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected long getLastUpdated(File repo) {
        long lastUpdatedOn = 0L;
        File timestampFile = new File(String.valueOf(repo) + ".properties");
        if (timestampFile.isFile()) {
            try (FileInputStream is = new FileInputStream(timestampFile);){
                Properties props = new Properties();
                props.load(is);
                lastUpdatedOn = Integer.parseInt(props.getProperty("LAST_UPDATED", "0"));
            }
            catch (IOException | NumberFormatException ex) {
                LOGGER.debug("error reading timestamp file", (Throwable)ex);
            }
            if (lastUpdatedOn <= 0L) {
                lastUpdatedOn = repo.lastModified();
            }
        }
        return lastUpdatedOn;
    }
}

