/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.utils.DependencyVersion;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.ICpe;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.util.Convert;
import us.springett.parsers.cpe.values.LogicalValue;
import us.springett.parsers.cpe.values.Part;

@ThreadSafe
public class VulnerableSoftware
extends Cpe
implements Serializable {
    private static final long serialVersionUID = 605319412326651052L;
    private final String versionEndExcluding;
    private final String versionEndIncluding;
    private final String versionStartExcluding;
    private final String versionStartIncluding;
    private final boolean vulnerable;

    public VulnerableSoftware(Part part, String vendor, String product, String version, String update, String edition, String language, String swEdition, String targetSw, String targetHw, String other, String versionEndExcluding, String versionEndIncluding, String versionStartExcluding, String versionStartIncluding, boolean vulnerable) throws CpeValidationException {
        super(part, vendor, product, version, update, edition, language, swEdition, targetSw, targetHw, other);
        this.versionEndExcluding = versionEndExcluding;
        this.versionEndIncluding = versionEndIncluding;
        this.versionStartExcluding = versionStartExcluding;
        this.versionStartIncluding = versionStartIncluding;
        this.vulnerable = vulnerable;
    }

    public int compareTo(@NotNull ICpe o) {
        if (o instanceof VulnerableSoftware) {
            VulnerableSoftware other = (VulnerableSoftware)o;
            return new CompareToBuilder().appendSuper(super.compareTo((ICpe)other)).append((Object)this.versionStartIncluding, (Object)other.versionStartIncluding).append((Object)this.versionStartExcluding, (Object)other.versionStartExcluding).append((Object)this.versionEndIncluding, (Object)other.versionEndIncluding).append((Object)this.versionEndExcluding, (Object)other.versionEndExcluding).append(this.vulnerable, other.vulnerable).build();
        }
        if (o instanceof Cpe) {
            return super.compareTo(o);
        }
        throw new UnexpectedAnalysisException("Unable to compare " + o.getClass().getCanonicalName());
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 59).appendSuper(super.hashCode()).append((Object)this.versionEndExcluding).append((Object)this.versionEndIncluding).append((Object)this.versionStartExcluding).append((Object)this.versionStartIncluding).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VulnerableSoftware)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        VulnerableSoftware rhs = (VulnerableSoftware)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.versionEndExcluding, (Object)rhs.versionEndExcluding).append((Object)this.versionEndIncluding, (Object)rhs.versionEndIncluding).append((Object)this.versionStartExcluding, (Object)rhs.versionStartExcluding).append((Object)this.versionStartIncluding, (Object)rhs.versionStartIncluding).isEquals();
    }

    public boolean matches(ICpe target) {
        boolean result = this.vulnerable;
        result &= VulnerableSoftware.compareAttributes((Part)this.getPart(), (Part)target.getPart());
        result &= VulnerableSoftware.compareAttributes((String)this.getVendor(), (String)target.getVendor());
        result &= VulnerableSoftware.compareAttributes((String)this.getProduct(), (String)target.getProduct());
        result &= this.compareVersionRange(target.getVersion());
        result &= VulnerableSoftware.compareUpdateAttributes(this.getUpdate(), target.getUpdate());
        result &= VulnerableSoftware.compareAttributes((String)this.getEdition(), (String)target.getEdition());
        result &= VulnerableSoftware.compareAttributes((String)this.getLanguage(), (String)target.getLanguage());
        result &= VulnerableSoftware.compareAttributes((String)this.getSwEdition(), (String)target.getSwEdition());
        result &= VulnerableSoftware.compareAttributes((String)this.getTargetSw(), (String)target.getTargetSw());
        result &= VulnerableSoftware.compareAttributes((String)this.getTargetHw(), (String)target.getTargetHw());
        return result &= VulnerableSoftware.compareAttributes((String)this.getOther(), (String)target.getOther());
    }

    protected static boolean compareUpdateAttributes(String left, String right) {
        String rightValue;
        if (left.equalsIgnoreCase(right)) {
            return true;
        }
        if (LogicalValue.ANY.getAbbreviation().equals(left)) {
            return true;
        }
        if (LogicalValue.NA.getAbbreviation().equals(left) && LogicalValue.ANY.getAbbreviation().equals(right)) {
            return true;
        }
        if (LogicalValue.NA.getAbbreviation().equals(left)) {
            return false;
        }
        if (LogicalValue.NA.getAbbreviation().equals(right)) {
            return false;
        }
        if (LogicalValue.ANY.getAbbreviation().equals(right)) {
            return true;
        }
        String leftValue = left.replace("-", "").replace("_", "");
        if (leftValue.equalsIgnoreCase(rightValue = right.replace("-", "").replace("_", ""))) {
            return true;
        }
        boolean results = false;
        if (VulnerableSoftware.containsSpecialCharacter(left)) {
            Pattern p = Convert.wellFormedToPattern((String)left.toLowerCase());
            Matcher m = p.matcher(right.toLowerCase());
            results = m.matches();
        }
        if (!results && rightValue.matches("^[abu]\\d.*") && leftValue.matches("^(update|alpha|beta).*")) {
            switch (right.charAt(0)) {
                case 'u': {
                    results = VulnerableSoftware.compareUpdateAttributes(leftValue, "update" + rightValue.substring(1));
                    break;
                }
                case 'a': {
                    results = VulnerableSoftware.compareUpdateAttributes(leftValue, "alpha" + rightValue.substring(1));
                    break;
                }
                case 'b': {
                    results = VulnerableSoftware.compareUpdateAttributes(leftValue, "beta" + rightValue.substring(1));
                    break;
                }
            }
        }
        if (!results && leftValue.matches("^[abu]\\d.*") && rightValue.matches("^(update|alpha|beta).*")) {
            switch (left.charAt(0)) {
                case 'u': {
                    results = VulnerableSoftware.compareUpdateAttributes("update" + leftValue.substring(1), rightValue);
                    break;
                }
                case 'a': {
                    results = VulnerableSoftware.compareUpdateAttributes("alpha" + leftValue.substring(1), rightValue);
                    break;
                }
                case 'b': {
                    results = VulnerableSoftware.compareUpdateAttributes("beta" + leftValue.substring(1), rightValue);
                    break;
                }
            }
        }
        return results;
    }

    private static boolean containsSpecialCharacter(String value) {
        for (int x = 0; x < value.length(); ++x) {
            char c = value.charAt(x);
            if (c == '?' || c == '*') {
                return true;
            }
            if (c != '\\') continue;
            ++x;
        }
        return false;
    }

    public static boolean testMatch(ICpe left, ICpe right) {
        boolean result = true;
        result &= VulnerableSoftware.compareAttributes((Part)left.getPart(), (Part)right.getPart());
        result &= VulnerableSoftware.compareAttributes((String)left.getWellFormedVendor(), (String)right.getWellFormedVendor());
        result &= VulnerableSoftware.compareAttributes((String)left.getWellFormedProduct(), (String)right.getWellFormedProduct());
        if (right instanceof VulnerableSoftware) {
            VulnerableSoftware vs = (VulnerableSoftware)right;
            result &= vs.vulnerable;
            result &= VulnerableSoftware.compareVersions(vs, left.getVersion());
        } else if (left instanceof VulnerableSoftware) {
            VulnerableSoftware vs = (VulnerableSoftware)left;
            result &= vs.vulnerable;
            result &= VulnerableSoftware.compareVersions(vs, right.getVersion());
        } else {
            result &= VulnerableSoftware.compareAttributes((String)left.getWellFormedVersion(), (String)right.getWellFormedVersion());
        }
        result &= VulnerableSoftware.compareUpdateAttributes(left.getWellFormedUpdate(), right.getWellFormedUpdate());
        result &= VulnerableSoftware.compareAttributes((String)left.getWellFormedEdition(), (String)right.getWellFormedEdition());
        result &= VulnerableSoftware.compareAttributes((String)left.getWellFormedLanguage(), (String)right.getWellFormedLanguage());
        result &= VulnerableSoftware.compareAttributes((String)left.getWellFormedSwEdition(), (String)right.getWellFormedSwEdition());
        result &= VulnerableSoftware.compareAttributes((String)left.getWellFormedTargetSw(), (String)right.getWellFormedTargetSw());
        result &= VulnerableSoftware.compareAttributes((String)left.getWellFormedTargetHw(), (String)right.getWellFormedTargetHw());
        return result &= VulnerableSoftware.compareAttributes((String)left.getWellFormedOther(), (String)right.getWellFormedOther());
    }

    public boolean matchedBy(ICpe target) {
        return VulnerableSoftware.testMatch(target, (ICpe)this);
    }

    protected boolean compareVersionRange(String targetVersion) {
        return VulnerableSoftware.compareVersions(this, targetVersion);
    }

    protected static boolean compareVersions(VulnerableSoftware vs, String targetVersion) {
        boolean result;
        if (LogicalValue.NA.getAbbreviation().equals(vs.getVersion())) {
            return false;
        }
        boolean bl = result = vs.versionEndExcluding != null && !vs.versionEndExcluding.isEmpty() || vs.versionStartExcluding != null && !vs.versionStartExcluding.isEmpty() || vs.versionEndIncluding != null && !vs.versionEndIncluding.isEmpty() || vs.versionStartIncluding != null && !vs.versionStartIncluding.isEmpty();
        if (!result && VulnerableSoftware.compareAttributes((String)vs.getVersion(), (String)targetVersion)) {
            return true;
        }
        DependencyVersion target = new DependencyVersion(targetVersion);
        if (target.getVersionParts().isEmpty()) {
            return false;
        }
        if (result && vs.versionEndExcluding != null && !vs.versionEndExcluding.isEmpty()) {
            DependencyVersion endExcluding = new DependencyVersion(vs.versionEndExcluding);
            boolean bl2 = result = endExcluding.compareTo(target) > 0;
        }
        if (result && vs.versionStartExcluding != null && !vs.versionStartExcluding.isEmpty()) {
            DependencyVersion startExcluding = new DependencyVersion(vs.versionStartExcluding);
            boolean bl3 = result = startExcluding.compareTo(target) < 0;
        }
        if (result && vs.versionEndIncluding != null && !vs.versionEndIncluding.isEmpty()) {
            DependencyVersion endIncluding = new DependencyVersion(vs.versionEndIncluding);
            result &= endIncluding.compareTo(target) >= 0;
        }
        if (result && vs.versionStartIncluding != null && !vs.versionStartIncluding.isEmpty()) {
            DependencyVersion startIncluding = new DependencyVersion(vs.versionStartIncluding);
            result &= startIncluding.compareTo(target) <= 0;
        }
        return result;
    }

    public String getVersionEndExcluding() {
        return this.versionEndExcluding;
    }

    public String getVersionEndIncluding() {
        return this.versionEndIncluding;
    }

    public String getVersionStartExcluding() {
        return this.versionStartExcluding;
    }

    public String getVersionStartIncluding() {
        return this.versionStartIncluding;
    }

    public boolean isVulnerable() {
        return this.vulnerable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toCpe23FS());
        boolean textAdded = false;
        if (this.versionStartIncluding != null && !this.versionStartIncluding.isEmpty()) {
            sb.append(" versions from (including) ").append(this.versionStartIncluding);
            textAdded = true;
        }
        if (this.versionStartExcluding != null && !this.versionStartExcluding.isEmpty()) {
            if (textAdded) {
                sb.append(";");
            }
            sb.append(" versions from (excluding) ").append(this.versionStartExcluding);
            textAdded = true;
        }
        if (this.versionEndIncluding != null && !this.versionEndIncluding.isEmpty()) {
            if (textAdded) {
                sb.append(";");
            }
            sb.append(" versions up to (including) ").append(this.versionEndIncluding);
            textAdded = true;
        }
        if (this.versionEndExcluding != null && !this.versionEndExcluding.isEmpty()) {
            if (textAdded) {
                sb.append(";");
            }
            sb.append(" versions up to (excluding) ").append(this.versionEndExcluding);
            textAdded = true;
        }
        if (!this.vulnerable) {
            if (textAdded) {
                sb.append(";");
            }
            sb.append(" version is NOT VULNERABLE");
        }
        return sb.toString();
    }

    public String toNvdSearchUrl() {
        return CpeIdentifier.nvdSearchUrlFor(this);
    }
}

