/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;

@ThreadSafe
public class NvdCveAnalyzer
extends AbstractAnalyzer {
    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        List<Vulnerability> vulns;
        String value;
        CveDB cveDB = engine.getDatabase();
        for (Identifier id : dependency.getIdentifiers()) {
            if (!"cpe".equals(id.getType())) continue;
            try {
                value = id.getValue();
                vulns = cveDB.getVulnerabilities(value);
                dependency.addVulnerabilities(vulns);
            }
            catch (DatabaseException ex) {
                throw new AnalysisException(ex);
            }
        }
        for (Identifier id : dependency.getSuppressedIdentifiers()) {
            if (!"cpe".equals(id.getType())) continue;
            try {
                value = id.getValue();
                vulns = cveDB.getVulnerabilities(value);
                dependency.addSuppressedVulnerabilities(vulns);
            }
            catch (DatabaseException ex) {
                throw new AnalysisException(ex);
            }
        }
    }

    @Override
    public String getName() {
        return "NVD CVE Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nvdcve.enabled";
    }
}

