
package org.owasp.dependencycheck.data.nvd.json;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class VendorDatum {

    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("vendor_name")
    @Expose
    private String vendorName;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("product")
    @Expose
    private Product product;

    /**
     * 
     * (Required)
     * 
     */
    public String getVendorName() {
        return vendorName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Product getProduct() {
        return product;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VendorDatum.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("vendorName");
        sb.append('=');
        sb.append(((this.vendorName == null)?"<null>":this.vendorName));
        sb.append(',');
        sb.append("product");
        sb.append('=');
        sb.append(((this.product == null)?"<null>":this.product));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.vendorName == null)? 0 :this.vendorName.hashCode()));
        result = ((result* 31)+((this.product == null)? 0 :this.product.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof VendorDatum) == false) {
            return false;
        }
        VendorDatum rhs = ((VendorDatum) other);
        return (((this.vendorName == rhs.vendorName)||((this.vendorName!= null)&&this.vendorName.equals(rhs.vendorName)))&&((this.product == rhs.product)||((this.product!= null)&&this.product.equals(rhs.product))));
    }

}
